/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.TerminalLocalNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProcessBuilder
implements Callable<Process> {
    private final NativeProcessInfo info;
    private ExternalTerminal externalTerminal = null;

    private NativeProcessBuilder(ExecutionEnvironment executionEnvironment) {
        this.info = new NativeProcessInfo(executionEnvironment);
    }

    public static NativeProcessBuilder newProcessBuilder(ExecutionEnvironment executionEnvironment) {
        return new NativeProcessBuilder(executionEnvironment);
    }

    public static NativeProcessBuilder newLocalProcessBuilder() {
        return new NativeProcessBuilder(ExecutionEnvironmentFactory.getLocal());
    }

    public void redirectError() {
        this.info.redirectError(true);
    }

    public NativeProcessBuilder setExecutable(String string) {
        this.info.setExecutable(string);
        return this;
    }

    public NativeProcessBuilder setCommandLine(String string) {
        this.info.setCommandLine(string);
        return this;
    }

    public NativeProcessBuilder addNativeProcessListener(ChangeListener changeListener) {
        this.info.addNativeProcessListener(changeListener);
        return this;
    }

    public MacroMap getEnvironment() {
        return this.info.getEnvironment();
    }

    @Override
    public NativeProcess call() throws IOException {
        AbstractNativeProcess abstractNativeProcess = null;
        if (this.info.getExecutionEnvironment().isRemote()) {
            abstractNativeProcess = new RemoteNativeProcess(this.info);
        } else {
            if (this.externalTerminal != null) {
                boolean bl = true;
                boolean bl2 = this.externalTerminal.isAvailable(this.info.getExecutionEnvironment());
                if (!bl2) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoTermianl.text", new String[0]), 2));
                    bl = false;
                } else {
                    if (Utilities.isWindows()) {
                        Shell shell = WindowsSupport.getInstance().getActiveShell();
                        if (shell == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoShell.text", new String[0]), 2));
                            bl = false;
                        } else {
                            ShellValidationSupport.ShellValidationStatus shellValidationStatus = ShellValidationSupport.getValidationStatus(shell);
                            if (!shellValidationStatus.isValid()) {
                                bl = ShellValidationSupport.confirm(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationHeader.text", new String[0]), NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationFooter.text", new String[0]), shellValidationStatus);
                            }
                        }
                    }
                    if (bl) {
                        abstractNativeProcess = new TerminalLocalNativeProcess(this.info, this.externalTerminal);
                    }
                }
            }
            if (abstractNativeProcess == null) {
                abstractNativeProcess = new LocalNativeProcess(this.info);
            }
        }
        return abstractNativeProcess.createAndStart();
    }

    public NativeProcessBuilder setWorkingDirectory(String string) {
        this.info.setWorkingDirectory(string);
        return this;
    }

    public NativeProcessBuilder setArguments(String ... stringArray) {
        this.info.setArguments(stringArray);
        return this;
    }

    public NativeProcessBuilder useExternalTerminal(ExternalTerminal externalTerminal) {
        this.externalTerminal = externalTerminal;
        return this;
    }

    public NativeProcessBuilder unbufferOutput(boolean bl) {
        this.info.setUnbuffer(bl);
        return this;
    }

    public NativeProcessBuilder setX11Forwarding(boolean bl) {
        if (Boolean.getBoolean("cnd.remote.noX11")) {
            return this;
        }
        this.info.setX11Forwarding(bl);
        return this;
    }

    public NativeProcessBuilder setInitialSuspend(boolean bl) {
        this.info.setInitialSuspend(bl);
        return this;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(NativeProcessBuilder.class, (String)string, (Object[])stringArray);
    }
}

