/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroMap
implements Cloneable {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final ExecutionEnvironment execEnv;
    private final MacroExpanderFactory.MacroExpander macroExpander;
    private final TreeMap<String, String> map;
    private final boolean isWindows;

    private MacroMap(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.macroExpander = MacroExpanderFactory.getExpander(executionEnvironment);
        this.isWindows = executionEnvironment.isLocal() && Utilities.isWindows();
        this.map = this.isWindows ? new TreeMap(new CaseInsensitiveComparator()) : new TreeMap();
    }

    public static final MacroMap forExecEnv(ExecutionEnvironment executionEnvironment) {
        return new MacroMap(executionEnvironment);
    }

    public final void putAll(MacroMap macroMap) {
        if (macroMap == null) {
            return;
        }
        this.putAll(macroMap.map);
    }

    public final void putAll(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public final void putAll(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            this.put(EnvUtils.getKey(string), EnvUtils.getValue(string));
        }
    }

    public String put(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            log.log(Level.INFO, "Attempt to set env variable '%s' with null value", string);
        }
        String string3 = string2;
        TreeMap<String, String> treeMap = this.isWindows ? new TreeMap<String, String>(new CaseInsensitiveComparator()) : new TreeMap();
        String string4 = this.map.get(string);
        if (string4 != null) {
            treeMap.put(string, string4);
        }
        try {
            string3 = this.macroExpander.expandMacros(string2, treeMap);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.map.put(string, string3);
    }

    public String get(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.map.get(string);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    public MacroMap clone() {
        MacroMap macroMap = new MacroMap(this.execEnv);
        macroMap.map.putAll(this.map);
        return macroMap;
    }

    public void prependPathVariable(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = this.get(string);
        String string4 = string2 + (string3 == null ? "" : (this.isWindows ? (char)';' : ':') + string3);
        this.put(string, string4);
    }

    public void appendPathVariable(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = this.get(string);
        String string4 = (string3 == null ? "" : string3 + (this.isWindows ? (char)';' : ':')) + string2;
        this.put(string, string4);
    }

    public void dump(PrintStream printStream) {
        for (Map.Entry<String, String> entry : this.entrySet()) {
            printStream.printf("Environment: %s=%s\n", entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.toUpperCase().compareTo(string2.toUpperCase());
        }
    }
}

