/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.openide.util.Exceptions;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Encrypter {
    private final EncryptionAlgorythm algo;

    public Encrypter(String string) {
        if (string == null) {
            throw new NullPointerException("passPhrase cannot be NULL");
        }
        if (string.length() < 8) {
            throw new RuntimeException("passPhrase cannot be less than 8 characters");
        }
        EncryptionAlgorythm encryptionAlgorythm = null;
        try {
            encryptionAlgorythm = new DESEncrypter(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            encryptionAlgorythm = new XOREncrypter(string);
        }
        this.algo = encryptionAlgorythm;
    }

    public String encrypt(String string) {
        return this.algo.encrypt(string);
    }

    public char[] encrypt(char[] cArray) {
        return this.algo.encrypt(String.valueOf(cArray)).toCharArray();
    }

    public String decrypt(String string) {
        return this.algo.decrypt(string);
    }

    public char[] decrypt(char[] cArray) {
        return this.algo.decrypt(String.valueOf(cArray)).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getFileChecksum(String string) {
        CRC32 cRC32;
        block13: {
            File file = new File(string);
            if (file == null || !file.exists()) {
                return -1L;
            }
            cRC32 = new CRC32();
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
            if (bufferedInputStream == null) {
                return -1L;
            }
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                cRC32.update(byArray, 0, n);
            }
            Object var8_7 = null;
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            break block13;
            {
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    Object var8_8 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException2) {
                        Exceptions.printStackTrace((Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                throw throwable;
            }
        }
        return cRC32.getValue();
    }

    public static boolean checkCRC32(String string, long l) {
        return l == Encrypter.getFileChecksum(string);
    }

    private static class XOREncrypter
    implements EncryptionAlgorythm {
        private static final String emptyPwd = "$$$EmptyPassword$$$";
        private static final char delimeter = '\u0000';
        private final byte[] passPhrase;

        public XOREncrypter(String string) {
            this.passPhrase = string.getBytes();
        }

        public String encrypt(String string) {
            if (string != null && string.length() == 0) {
                string = emptyPwd;
            }
            return this.xor(string + '\u0000');
        }

        public String decrypt(String string) {
            int n;
            String string2 = this.xor(string);
            int n2 = n = string2 == null ? -1 : string2.indexOf(0);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            if (emptyPwd.equals(string2)) {
                string2 = "";
            }
            return string2;
        }

        private String xor(String string) {
            if (string == null) {
                return null;
            }
            byte[] byArray = string.getBytes();
            int n = Math.max(this.passPhrase.length, byArray.length);
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = (byte)(byArray[i % byArray.length] ^ this.passPhrase[i % this.passPhrase.length]);
            }
            return new String(byArray2);
        }
    }

    private static class DESEncrypter
    implements EncryptionAlgorythm {
        private SecretKey key;
        private BASE64Encoder base64encoder = new BASE64Encoder();
        private BASE64Decoder base64decoder = new BASE64Decoder();

        public DESEncrypter(String string) throws NoSuchAlgorithmException {
            try {
                DESKeySpec dESKeySpec = new DESKeySpec(string.getBytes("UTF8"));
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
                this.key = secretKeyFactory.generateSecret(dESKeySpec);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                Exceptions.printStackTrace((Throwable)invalidKeySpecException);
            }
            catch (InvalidKeyException invalidKeyException) {
                Exceptions.printStackTrace((Throwable)invalidKeyException);
            }
        }

        public synchronized String encrypt(String string) {
            String string2 = null;
            try {
                byte[] byArray = string.getBytes("UTF8");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(1, this.key);
                string2 = this.base64encoder.encode(cipher.doFinal(byArray));
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                Exceptions.printStackTrace((Throwable)illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                Exceptions.printStackTrace((Throwable)badPaddingException);
            }
            catch (InvalidKeyException invalidKeyException) {
                Exceptions.printStackTrace((Throwable)invalidKeyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Exceptions.printStackTrace((Throwable)noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                Exceptions.printStackTrace((Throwable)noSuchPaddingException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            }
            return string2;
        }

        public synchronized String decrypt(String string) {
            String string2 = "";
            try {
                byte[] byArray = this.base64decoder.decodeBuffer(string);
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, this.key);
                byte[] byArray2 = cipher.doFinal(byArray);
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray2) {
                    stringBuilder.append((char)by);
                }
                string2 = stringBuilder.toString();
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                Exceptions.printStackTrace((Throwable)illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                Exceptions.printStackTrace((Throwable)badPaddingException);
            }
            catch (InvalidKeyException invalidKeyException) {
                Exceptions.printStackTrace((Throwable)invalidKeyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Exceptions.printStackTrace((Throwable)noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                Exceptions.printStackTrace((Throwable)noSuchPaddingException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return string2;
        }
    }

    private static interface EncryptionAlgorythm {
        public String encrypt(String var1);

        public String decrypt(String var1);
    }
}

