/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionJList;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionScrollPane
extends JScrollPane {
    private static final String ESCAPE = "escape";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final int ACTION_ESCAPE = 0;
    private static final int ACTION_COMPLETION_UP = 1;
    private static final int ACTION_COMPLETION_DOWN = 2;
    private static final int ACTION_COMPLETION_PGUP = 3;
    private static final int ACTION_COMPLETION_PGDN = 4;
    private static final int ACTION_COMPLETION_BEGIN = 5;
    private static final int ACTION_COMPLETION_END = 6;
    private CompletionJList view;
    private List dataObj;
    private JLabel topLabel;

    public CompletionScrollPane(JTextComponent jTextComponent, ListSelectionListener listSelectionListener, MouseListener mouseListener) {
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(20);
        this.setMaximumSize(CompletionSettings.getInstance(jTextComponent).completionPaneMaximumSize());
        int n = Math.max(2, this.getMaximumSize().height / 16 - 1);
        this.view = new CompletionJList(n, mouseListener, jTextComponent);
        if (listSelectionListener != null) {
            this.view.addListSelectionListener(listSelectionListener);
        }
        this.setViewportView(this.view);
        this.installKeybindings(jTextComponent);
    }

    public void setData(List list, String string, int n) {
        this.dataObj = list;
        this.view.setData(list);
        this.view.setSelectedIndex(n);
        Rectangle rectangle = this.view.getCellBounds(n, n);
        if (rectangle != null) {
            this.view.scrollRectToVisible(rectangle);
        }
        this.setTitle(string);
        this.setViewportView(this.getViewport().getView());
    }

    public CompletionItem getSelectedCompletionItem() {
        Object e = this.view.getSelectedValue();
        return e instanceof CompletionItem ? (CompletionItem)e : null;
    }

    public int getSelectedIndex() {
        return this.view.getSelectedIndex();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.topLabel != null ? this.topLabel.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension3 = this.getMaximumSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.width > dimension3.width) {
            dimension.width = dimension3.width;
        }
        return dimension;
    }

    private void setTitle(String string) {
        if (string == null) {
            if (this.topLabel != null) {
                this.setColumnHeader(null);
                this.topLabel = null;
            }
        } else if (this.topLabel != null) {
            this.topLabel.setText(string);
        } else {
            this.topLabel = new JLabel(string);
            this.topLabel.setForeground(Color.blue);
            this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setColumnHeaderView(this.topLabel);
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke, JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (jTextComponent != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(int n, String string, KeyStroke keyStroke, String string2, JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke, jTextComponent);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.getInputMap().put(keyStrokeArray[i], string);
        }
        this.getActionMap().put(string, new CompletionPaneAction(n));
    }

    private void installKeybindings(JTextComponent jTextComponent) {
        this.registerKeybinding(0, ESCAPE, KeyStroke.getKeyStroke(27, 0), ESCAPE, jTextComponent);
        this.registerKeybinding(1, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up", jTextComponent);
        this.registerKeybinding(2, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down", jTextComponent);
        this.registerKeybinding(4, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down", jTextComponent);
        this.registerKeybinding(3, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up", jTextComponent);
        this.registerKeybinding(5, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line", jTextComponent);
        this.registerKeybinding(6, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line", jTextComponent);
    }

    List testGetData() {
        return this.dataObj;
    }

    private class CompletionPaneAction
    extends AbstractAction {
        private int action;

        private CompletionPaneAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    LogRecord logRecord = new LogRecord(Level.FINE, "COMPL_CANCEL");
                    CompletionImpl.uilog(logRecord);
                    CompletionImpl.get().hideCompletion(false);
                    break;
                }
                case 1: {
                    CompletionScrollPane.this.view.up();
                    break;
                }
                case 2: {
                    CompletionScrollPane.this.view.down();
                    break;
                }
                case 3: {
                    CompletionScrollPane.this.view.pageUp();
                    break;
                }
                case 4: {
                    CompletionScrollPane.this.view.pageDown();
                    break;
                }
                case 5: {
                    CompletionScrollPane.this.view.begin();
                    break;
                }
                case 6: {
                    CompletionScrollPane.this.view.end();
                }
            }
        }
    }
}

