/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public final class CompletionSettings {
    private static final Logger LOG = Logger.getLogger(CompletionSettings.class.getName());
    private Preferences preferences = null;

    public static synchronized CompletionSettings getInstance(JTextComponent jTextComponent) {
        return new CompletionSettings(jTextComponent != null ? DocumentUtilities.getMimeType((JTextComponent)jTextComponent) : null);
    }

    public boolean completionAutoPopup() {
        return this.preferences.getBoolean("completion-auto-popup", true);
    }

    public int completionAutoPopupDelay() {
        return this.preferences.getInt("completion-auto-popup-delay", 250);
    }

    public boolean documentationAutoPopup() {
        return this.preferences.getBoolean("javadoc-auto-popup", true);
    }

    boolean documentationPopupNextToCC() {
        return this.preferences.getBoolean("javadoc-popup-next-to-cc", false);
    }

    public int documentationAutoPopupDelay() {
        return this.preferences.getInt("javadoc-auto-popup-delay", 200);
    }

    public Dimension completionPaneMaximumSize() {
        return CompletionSettings.parseDimension(this.preferences.get("completion-pane-max-size", null), new Dimension(400, 300));
    }

    public Dimension documentationPopupPreferredSize() {
        return CompletionSettings.parseDimension(this.preferences.get("javadoc-preferred-size", null), new Dimension(500, 300));
    }

    public boolean completionInstantSubstitution() {
        return this.preferences.getBoolean("completion-instant-substitution", true);
    }

    private CompletionSettings(String string) {
        this.preferences = (Preferences)(string != null ? MimeLookup.getLookup((String)string) : MimeLookup.getLookup((MimePath)MimePath.EMPTY)).lookup(Preferences.class);
    }

    private static Dimension parseDimension(String string, Dimension dimension) {
        int[] nArray = new int[2];
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                if (n > 1) {
                    return dimension;
                }
                try {
                    nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.WARNING, null, numberFormatException);
                    return dimension;
                }
                ++n;
            }
        }
        if (n != 2) {
            return dimension;
        }
        return new Dimension(nArray[0], nArray[1]);
    }
}

