/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;

class ElementResultItem
extends XMLResultItem {
    private final boolean startElement;
    private final boolean empty;
    private GrammarResult res;

    public ElementResultItem(GrammarResult grammarResult) {
        super(grammarResult.getNodeName());
        this.res = grammarResult;
        this.foreground = Color.blue;
        this.startElement = true;
        this.empty = grammarResult.isEmptyElement();
        this.icon = grammarResult.getIcon(1);
    }

    public ElementResultItem(String string) {
        super(string);
        this.foreground = Color.blue;
        this.startElement = false;
        this.empty = false;
    }

    public String getReplacementText(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        if (bl && this.startElement) {
            if (this.empty) {
                return this.displayText + "/>";
            }
            return this.displayText + ">";
        }
        if (this.startElement) {
            return this.displayText;
        }
        return this.displayText + '>';
    }

    public CompletionTask createDocumentationTask() {
        return new CompletionTask(){

            public void query(CompletionResultSet completionResultSet) {
                if (ElementResultItem.this.res != null && ElementResultItem.this.res.getDescription() != null) {
                    completionResultSet.setDocumentation((CompletionDocumentation)new Docum(ElementResultItem.this.res.getDescription()));
                }
                completionResultSet.finish();
            }

            public void refresh(CompletionResultSet completionResultSet) {
                if (ElementResultItem.this.res != null && ElementResultItem.this.res.getDescription() != null) {
                    completionResultSet.setDocumentation((CompletionDocumentation)new Docum(ElementResultItem.this.res.getDescription()));
                }
                completionResultSet.finish();
            }

            public void cancel() {
            }
        };
    }

    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, int n3) {
        boolean bl;
        String string = this.getReplacementText(n3);
        this.replaceText(jTextComponent, string, n, n2);
        boolean bl2 = bl = (n3 & 1) != 0;
        if (bl && this.startElement) {
            Caret caret = jTextComponent.getCaret();
            int n4 = caret.getDot();
            int n5 = string.length();
            if (this.empty) {
                caret.setDot(n4 - n5 + string.indexOf(47));
            }
        }
        return false;
    }

    Color getPaintColor() {
        return Color.blue;
    }

    private class Docum
    implements CompletionDocumentation {
        private String doc;

        private Docum(String string) {
            this.doc = string;
        }

        public String getText() {
            return this.doc;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String string) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

