/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.util.WeakHashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.dom.CDATASection;
import org.netbeans.modules.xml.text.dom.Comment;
import org.netbeans.modules.xml.text.dom.DocumentType;
import org.netbeans.modules.xml.text.dom.EmptyTag;
import org.netbeans.modules.xml.text.dom.EndTag;
import org.netbeans.modules.xml.text.dom.ProcessingInstruction;
import org.netbeans.modules.xml.text.dom.StartTag;
import org.netbeans.modules.xml.text.dom.SyntaxElement;
import org.netbeans.modules.xml.text.dom.Text;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSyntaxSupport {
    private char lastInsertedChar = (char)88;
    private final DocumentMonitor documentMonitor;
    private BaseDocument document;
    private static WeakHashMap<BaseDocument, XMLSyntaxSupport> supportMap = new WeakHashMap();

    private XMLSyntaxSupport(BaseDocument baseDocument) {
        this.document = baseDocument;
        this.documentMonitor = new DocumentMonitor();
        DocumentListener documentListener = WeakListeners.document((DocumentListener)this.documentMonitor, (Object)baseDocument);
        baseDocument.addDocumentListener(documentListener);
    }

    public static XMLSyntaxSupport getSyntaxSupport(BaseDocument baseDocument) {
        XMLSyntaxSupport xMLSyntaxSupport = supportMap.get(baseDocument);
        if (xMLSyntaxSupport != null) {
            return xMLSyntaxSupport;
        }
        xMLSyntaxSupport = new XMLSyntaxSupport(baseDocument);
        supportMap.put(baseDocument, xMLSyntaxSupport);
        return xMLSyntaxSupport;
    }

    public BaseDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getPreviousToken(int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw new BadLocationException("Offset " + n + " cannot be less than 0.", n);
        }
        this.document.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = this.getToken(tokenSequence, n, false);
            return token;
        }
        finally {
            this.document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getNextToken(int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw new BadLocationException("Offset " + n + " cannot be less than 0.", n);
        }
        this.document.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = this.getToken(tokenSequence, n, true);
            return token;
        }
        finally {
            this.document.readUnlock();
        }
    }

    private Token getToken(TokenSequence tokenSequence, int n, boolean bl) {
        tokenSequence.move(n);
        Token token = tokenSequence.token();
        if (token == null) {
            tokenSequence.moveNext();
        }
        if (bl) {
            tokenSequence.moveNext();
        } else {
            tokenSequence.movePrevious();
        }
        token = tokenSequence.token();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxElement getElementChain(int n) throws BadLocationException {
        this.document.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = this.initialize(tokenSequence, n);
            if (token == null) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            switch ((XMLTokenId)token.id()) {
                case PI_START: 
                case PI_END: 
                case PI_CONTENT: 
                case PI_TARGET: {
                    while (true) {
                        if (token.id() == XMLTokenId.PI_START) {
                            SyntaxElement syntaxElement = this.createElement(tokenSequence, token);
                            return syntaxElement;
                        }
                        tokenSequence.movePrevious();
                        token = tokenSequence.token();
                    }
                }
                case TEXT: 
                case DECLARATION: 
                case CDATA_SECTION: 
                case BLOCK_COMMENT: 
                case TAG: 
                case ERROR: {
                    SyntaxElement syntaxElement = this.createElement(tokenSequence, token);
                    return syntaxElement;
                }
            }
            return null;
        }
        finally {
            this.document.readUnlock();
        }
    }

    private Token<XMLTokenId> initialize(TokenSequence tokenSequence, int n) {
        Token token;
        block3: {
            tokenSequence.move(n);
            token = tokenSequence.token();
            if (token == null) {
                if (!tokenSequence.moveNext()) {
                    return null;
                }
                token = tokenSequence.token();
            }
            XMLTokenId xMLTokenId = (XMLTokenId)token.id();
            String string = ((Object)token.text()).toString();
            if (xMLTokenId != XMLTokenId.WS && xMLTokenId != XMLTokenId.ARGUMENT && xMLTokenId != XMLTokenId.OPERATOR && xMLTokenId != XMLTokenId.VALUE && (xMLTokenId != XMLTokenId.TAG || !">".equals(string) && !"/>".equals(string))) break block3;
            do {
                tokenSequence.movePrevious();
            } while ((xMLTokenId = (XMLTokenId)(token = tokenSequence.token()).id()) != XMLTokenId.TAG && xMLTokenId != XMLTokenId.PI_START);
        }
        return token;
    }

    private SyntaxElement createElement(TokenSequence tokenSequence, Token<XMLTokenId> token) throws BadLocationException {
        int n = tokenSequence.offset();
        int n2 = n + token.length();
        switch ((XMLTokenId)token.id()) {
            case PI_START: {
                String string = null;
                String string2 = null;
                Token token2 = token;
                while (token2.id() != XMLTokenId.PI_END) {
                    if (token2.id() == XMLTokenId.PI_TARGET) {
                        string = ((Object)token2.text()).toString();
                    }
                    if (token2.id() == XMLTokenId.PI_CONTENT) {
                        string2 = ((Object)token2.text()).toString();
                    }
                    tokenSequence.moveNext();
                    token2 = tokenSequence.token();
                }
                n2 = tokenSequence.offset() + token2.length();
                return new ProcessingInstruction(this, (Token<XMLTokenId>)token, n, n2, string, string2);
            }
            case DECLARATION: {
                return new DocumentType(this, (Token<XMLTokenId>)token, n, n2);
            }
            case CDATA_SECTION: {
                return new CDATASection(this, (Token<XMLTokenId>)token, n, n2);
            }
            case BLOCK_COMMENT: {
                return new Comment(this, (Token<XMLTokenId>)token, n, n2);
            }
            case TEXT: {
                return new Text(this, token, n, n2);
            }
            case TAG: {
                Token token3 = token;
                do {
                    tokenSequence.moveNext();
                } while ((token3 = tokenSequence.token()).id() != XMLTokenId.TAG);
                n2 = tokenSequence.offset() + token3.length();
                if (((Object)token3.text()).toString().equals("/>")) {
                    return new EmptyTag(this, (Token<XMLTokenId>)token, n, n2);
                }
                if (((Object)token.text()).toString().startsWith("</")) {
                    return new EndTag(this, (Token<XMLTokenId>)token, n, n2);
                }
                return new StartTag(this, (Token<XMLTokenId>)token, n, n2);
            }
            case ERROR: {
                return new SyntaxElement.Error(this, token, n, n2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean noCompletion(JTextComponent jTextComponent) {
        if (jTextComponent == null || jTextComponent.getCaret() == null) {
            return false;
        }
        int n = jTextComponent.getCaret().getDot();
        if (n < 0) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        baseDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence == null) {
                boolean bl = false;
                return bl;
            }
            tokenSequence.move(n);
            Token token = tokenSequence.token();
            if (token == null) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (token.id() == XMLTokenId.CDATA_SECTION || token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.PI_START || token.id() == XMLTokenId.PI_END || token.id() == XMLTokenId.PI_CONTENT || token.id() == XMLTokenId.PI_TARGET) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return false;
    }

    public final char lastTypedChar() {
        return this.lastInsertedChar;
    }

    private class DocumentMonitor
    implements DocumentListener {
        private DocumentMonitor() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            try {
                String string = documentEvent.getDocument().getText(n + n2 - 1, 1);
                XMLSyntaxSupport.this.lastInsertedChar = string.charAt(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }
    }
}

