/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.CDATASectionImpl;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.DocumentTypeImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.ErrorManager;

public class XMLDocumentModelProvider
implements DocumentModelProvider {
    public static final String XML_TAG = "tag";
    public static final String XML_EMPTY_TAG = "empty_tag";
    public static final String XML_CONTENT = "content";
    public static final String XML_PI = "pi";
    public static final String XML_CDATA = "cdata";
    public static final String XML_DOCTYPE = "doctype";
    public static final String XML_COMMENT = "comment";
    public static final String XML_ERROR = "error";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.measure");

    public void updateModel(DocumentModel.DocumentModelModificationTransaction documentModelModificationTransaction, DocumentModel documentModel, DocumentModel.DocumentChange[] documentChangeArray) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        long l = System.currentTimeMillis();
        if (debug) {
            System.out.println("\n\n\n\n\n");
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure((DocumentElement)documentModel.getRootElement());
        }
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        for (int i = 0; i < documentChangeArray.length; ++i) {
            Object object;
            Object badLocationException;
            DocumentElement documentElement;
            DocumentElement documentElement2;
            int n;
            block37: {
                DocumentModel.DocumentChange documentChange = documentChangeArray[i];
                n = documentChange.getChangeStart().getOffset();
                int n2 = documentChange.getChangeLength();
                documentElement = documentElement2 = documentModel.getLeafElementForOffset(n);
                if (debug) {
                    System.out.println("");
                }
                if (debug) {
                    System.out.println(documentChange);
                }
                try {
                    if (debug) {
                        System.out.println("inserted text:'" + documentModel.getDocument().getText(n, n2) + "'");
                    }
                }
                catch (BadLocationException badLocationException2) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("leaf = " + documentElement2);
                }
                XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)documentModel.getDocument()).getSyntaxSupport();
                boolean bl = false;
                boolean bl2 = false;
                try {
                    for (badLocationException = xMLSyntaxSupport.getTokenChain(n, n + 1); badLocationException != null && badLocationException.getOffset() < n + n2; badLocationException = badLocationException.getNext()) {
                        if (badLocationException.getTokenID() == XMLTokenIDs.TEXT || badLocationException.getTokenID() == XMLTokenIDs.DECLARATION || badLocationException.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || badLocationException.getTokenID() == XMLTokenIDs.PI_CONTENT || badLocationException.getTokenID() == XMLTokenIDs.CDATA_SECTION) {
                            bl = true;
                        } else {
                            if (badLocationException.getTokenID() != XMLTokenIDs.ARGUMENT && badLocationException.getTokenID() != XMLTokenIDs.OPERATOR && badLocationException.getTokenID() != XMLTokenIDs.VALUE) continue;
                            bl2 = true;
                        }
                        break;
                    }
                }
                catch (BadLocationException badLocationException3) {
                    ErrorManager.getDefault().notify(16, (Throwable)badLocationException3);
                }
                if (bl && (documentElement2.getType().equals(XML_CONTENT) || documentElement2.getType().equals(XML_DOCTYPE) || documentElement2.getType().equals(XML_PI) || documentElement2.getType().equals(XML_COMMENT) || documentElement2.getType().equals(XML_CDATA))) {
                    if (debug) {
                        System.out.println("ONLY CONTENT UPDATE!!!");
                    }
                    documentModelModificationTransaction.updateDocumentElementText(documentElement2);
                    if (documentChange.getChangeLength() == 1) continue;
                }
                if ((bl2 || documentChange.getChangeType() == 1) && (documentElement2.getType().equals(XML_TAG) || documentElement2.getType().equals(XML_EMPTY_TAG))) {
                    if (debug) {
                        System.out.println("POSSIBLE ATTRIBS UPDATE!!!");
                    }
                    try {
                        badLocationException = xMLSyntaxSupport.getElementChain(documentElement2.getStartOffset() + 1);
                        if (!(badLocationException instanceof Tag) && !(badLocationException instanceof EmptyTag)) break block37;
                        Map map = this.createAttributesMap((Tag)badLocationException);
                        object = documentElement2.getAttributes();
                        boolean bl3 = false;
                        if (object.getAttributeCount() == map.size()) {
                            for (String string : map.keySet()) {
                                String string2 = (String)map.get(string);
                                if (string == null || string2 == null || object.containsAttribute(string, string2)) continue;
                                bl3 = true;
                                break;
                            }
                        } else {
                            bl3 = true;
                        }
                        if (bl3) {
                            documentModelModificationTransaction.updateDocumentElementAttribs(documentElement2, map);
                        }
                    }
                    catch (BadLocationException badLocationException4) {
                        ErrorManager.getDefault().notify(16, (Throwable)badLocationException4);
                    }
                }
            }
            if (documentElement2.getStartOffset() == documentElement2.getEndOffset() || n == documentElement2.getStartOffset() || n == documentElement2.getEndOffset()) {
                documentElement = documentElement2.getParentElement();
            } else if (documentElement2.getType().equals(XML_CONTENT)) {
                while ((documentElement = documentElement.getParentElement()) != null && documentElement.getType().equals(XML_CONTENT)) {
                }
                if (documentElement == null) {
                    documentElement = documentModel.getRootElement();
                }
            }
            if (documentElement == null) {
                documentElement = documentModel.getRootElement();
            }
            badLocationException = arrayList.iterator();
            boolean bl = false;
            while (badLocationException.hasNext()) {
                object = (DocumentElement)badLocationException.next();
                if (!object.equals((Object)documentElement) && !documentModel.isDescendantOf((DocumentElement)object, documentElement)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = new ArrayList();
            for (DocumentElement documentElement3 : arrayList) {
                if (!documentModel.isDescendantOf(documentElement, documentElement3)) continue;
                ((ArrayList)object).add(documentElement3);
            }
            arrayList.removeAll((Collection<?>)object);
            arrayList.add(documentElement);
            if (debug) {
                System.out.println("===================================================================");
            }
            if (debug) {
                System.out.println("change happened in " + documentElement2);
            }
            if (!debug) continue;
            System.out.println("we will regenerate its parent " + documentElement);
        }
        for (DocumentElement documentElement : arrayList) {
            this.generateDocumentElements(documentModelModificationTransaction, documentModel, documentElement);
        }
        if (measure) {
            System.out.println("[xmlmodel] generated in " + (System.currentTimeMillis() - l));
        }
    }

    private void generateDocumentElements(DocumentModel.DocumentModelModificationTransaction documentModelModificationTransaction, DocumentModel documentModel, DocumentElement documentElement) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        int n = documentElement.getStartOffset();
        int n2 = documentElement.getEndOffset();
        BaseDocument baseDocument = (BaseDocument)documentModel.getDocument();
        XMLSyntaxSupport xMLSyntaxSupport = new XMLSyntaxSupport(baseDocument);
        if (debug) {
            System.out.println("[XMLDocumentModelProvider] regenerating " + documentElement);
        }
        TreeSet<DocumentElement> treeSet = new TreeSet<DocumentElement>(DocumentModel.ELEMENTS_COMPARATOR);
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        try {
            Object object;
            Stack<SyntaxElement> stack = new Stack<SyntaxElement>();
            Object object2 = xMLSyntaxSupport.getElementChain(Math.min(baseDocument.getLength(), n + 1));
            while (object2 != null && this.getSyntaxElementEndOffset((SyntaxElement)object2) <= n2) {
                int n3;
                int n4;
                if (object2 instanceof SyntaxElement.Error) {
                    if (debug) {
                        System.out.println("Error found! => adding error element.");
                    }
                    object = baseDocument.getText(((SyntaxElement)object2).getElementOffset(), ((SyntaxElement)object2).getElementLength());
                    n4 = ((SyntaxElement)object2).getElementOffset();
                    if (n4 == (n3 = this.getSyntaxElementEndOffset((SyntaxElement)object2))) {
                        ++n3;
                    }
                    treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object, XML_ERROR, Collections.EMPTY_MAP, n4, n3));
                }
                if (object2 instanceof StartTag) {
                    SyntaxElement syntaxElement;
                    object = (StartTag)object2;
                    DocumentElement documentElement2 = DocumentModelUtils.findElement((DocumentModel)documentModel, (int)((SyntaxElement)object2).getElementOffset(), (String)((Tag)object).getTagName(), (String)XML_TAG);
                    if (documentElement2 != null && !documentElement2.equals((Object)documentElement) && (syntaxElement = xMLSyntaxSupport.getElementChain(Math.min(baseDocument.getLength(), documentElement2.getEndOffset() + 1))) instanceof EndTag && ((EndTag)syntaxElement).getTagName().equals(((Tag)object).getTagName())) {
                        if (debug) {
                            System.out.println("found existing element " + documentElement2 + " => skipping");
                        }
                        object2 = syntaxElement.getNext();
                        arrayList.add(documentElement2);
                        continue;
                    }
                    stack.push((SyntaxElement)object2);
                } else if (object2 instanceof EndTag) {
                    if (!stack.isEmpty()) {
                        Object object3;
                        object = (StartTag)stack.peek();
                        if (((EndTag)object2).getTagName().equals(((Tag)object).getTagName())) {
                            object3 = this.createAttributesMap((Tag)object);
                            treeSet.add(documentModelModificationTransaction.addDocumentElement(((Tag)object).getTagName(), XML_TAG, (Map)object3, ((SyntaxElement)object).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                            stack.pop();
                        } else {
                            object3 = new ArrayList();
                            n3 = 0;
                            while (!stack.isEmpty()) {
                                SyntaxElement syntaxElement = (SyntaxElement)stack.pop();
                                ((ArrayList)object3).add(syntaxElement);
                                Tag tag = (Tag)syntaxElement;
                                Tag tag2 = (Tag)object2;
                                if (!(syntaxElement instanceof StartTag) || !tag.getTagName().equals(tag2.getTagName())) continue;
                                Map map = this.createAttributesMap((StartTag)syntaxElement);
                                treeSet.add(documentModelModificationTransaction.addDocumentElement(tag.getTagName(), XML_TAG, map, tag.getElementOffset(), this.getSyntaxElementEndOffset(tag2)));
                                n3 = 1;
                                break;
                            }
                            if (n3 == 0) {
                                for (int i = ((ArrayList)object3).size() - 1; i >= 0; --i) {
                                    stack.push((SyntaxElement)((ArrayList)object3).get(i));
                                }
                            }
                        }
                    }
                } else if (object2 instanceof EmptyTag) {
                    object = this.createAttributesMap((Tag)object2);
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(((EmptyTag)object2).getTagName(), XML_EMPTY_TAG, (Map)object, ((SyntaxElement)object2).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                } else if (object2 instanceof CDATASectionImpl) {
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(XML_CDATA, XML_CDATA, Collections.EMPTY_MAP, ((SyntaxElement)object2).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                } else if (object2 instanceof ProcessingInstructionImpl) {
                    object = ((ProcessingInstructionImpl)object2).getNodeName();
                    if (object != null) {
                        treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object, XML_PI, Collections.EMPTY_MAP, ((SyntaxElement)object2).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                    }
                } else if (object2 instanceof DocumentTypeImpl) {
                    object = ((DocumentTypeImpl)object2).getName();
                    if (object != null) {
                        treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object, XML_DOCTYPE, Collections.EMPTY_MAP, ((SyntaxElement)object2).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                    }
                } else if (object2 instanceof CommentImpl) {
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(XML_COMMENT, XML_COMMENT, Collections.EMPTY_MAP, ((SyntaxElement)object2).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object2)));
                } else {
                    int n5 = ((SyntaxElement)object2).getElementOffset();
                    if (n5 < (n4 = this.getSyntaxElementEndOffset((SyntaxElement)object2))) {
                        treeSet.add(documentModelModificationTransaction.addDocumentElement("...", XML_CONTENT, Collections.EMPTY_MAP, n5, n4));
                    }
                }
                try {
                    object = null;
                    int n6 = 0;
                    while ((object = xMLSyntaxSupport.getElementChain(((SyntaxElement)object2).getElementOffset() + ((SyntaxElement)object2).getElementLength() + ++n6)) != null && ((SyntaxElement)object2).getElementOffset() >= ((SyntaxElement)object).getElementOffset()) {
                    }
                    object2 = object;
                }
                catch (BadLocationException badLocationException) {
                    object2 = null;
                }
            }
            object = this.getDescendantsOfNotSkippedElements(documentElement, arrayList);
            object.add(documentElement);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DocumentElement documentElement3 = (DocumentElement)iterator.next();
                if (treeSet.contains(documentElement3)) continue;
                documentModelModificationTransaction.removeDocumentElement(documentElement3, false);
                if (!debug) continue;
                System.out.println("[xml model] removed element " + documentElement3);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new DocumentModelException("Error occurred during generation of Document elements", (Throwable)badLocationException);
        }
    }

    private List getDescendantsOfNotSkippedElements(DocumentElement documentElement, List list) {
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        for (DocumentElement documentElement2 : documentElement.getChildren()) {
            if (list.contains(documentElement2)) continue;
            arrayList.add(documentElement2);
            arrayList.addAll(this.getDescendantsOfNotSkippedElements(documentElement2, list));
        }
        return arrayList;
    }

    private int getSyntaxElementEndOffset(SyntaxElement syntaxElement) {
        return syntaxElement.getElementOffset() + syntaxElement.getElementLength() - 1;
    }

    private Map createAttributesMap(Tag tag) {
        if (tag.getAttributes().getLength() == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(tag.getAttributes().getLength());
        for (int i = 0; i < tag.getAttributes().getLength(); ++i) {
            AttrImpl attrImpl = (AttrImpl)tag.getAttributes().item(i);
            linkedHashMap.put(attrImpl.getName(), attrImpl.getValue());
        }
        return linkedHashMap;
    }
}

