/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;

public class IdentifierSignature {
    private static final int DECLARATION = 1;
    private static final int IFACE_MEMBER = 2;
    private static final int CLS_MEMBER = 4;
    private static final int MODIFIER_STATIC = 8;
    private static final int MODIFIER_ABSTRACT = 16;
    private static final int MODIFIER_PROTECTED = 32;
    private static final int MODIFIER_PUBLIC = 64;
    private static final int KIND_FNC = 128;
    private static final int KIND_VAR = 256;
    private static final int KIND_CONST = 512;
    private static final int KIND_CLASS = 1024;
    private String name;
    private int mask;
    private String typeName;

    private IdentifierSignature(String string) {
        this(string, null, 0);
    }

    private IdentifierSignature(String string, String string2, int n) {
        this.name = string.toLowerCase();
        while (string.startsWith("$")) {
            string = string.substring(1);
        }
        this.mask = n;
        if (this.isDeclaration()) {
            this.typeName = string2;
        }
    }

    private IdentifierSignature(String string, int n, ElementKind elementKind, String string2, boolean bl, Boolean bl2) {
        this.name = string.toLowerCase();
        while (string.startsWith("$")) {
            string = string.substring(1);
        }
        if (bl) {
            this.mask |= 1;
        }
        if (bl2 != null && bl2.booleanValue()) {
            this.mask |= 4;
        }
        if (bl2 != null && !bl2.booleanValue()) {
            this.mask |= 2;
        }
        switch (elementKind) {
            case METHOD: {
                this.mask |= 0x80;
                break;
            }
            case FIELD: {
                this.mask |= 0x100;
                break;
            }
            case CONSTANT: {
                this.mask |= 0x200;
                break;
            }
            case CLASS: {
                this.mask |= 0x400;
                break;
            }
            default: {
                throw new IllegalStateException(elementKind.toString());
            }
        }
        if (BodyDeclaration.Modifier.isAbstract(n)) {
            this.mask |= 0x10;
        } else if (BodyDeclaration.Modifier.isStatic(n)) {
            this.mask |= 8;
        }
        if (BodyDeclaration.Modifier.isPublic(n)) {
            this.mask |= 0x40;
        } else if (BodyDeclaration.Modifier.isProtected(n)) {
            this.mask |= 0x20;
        }
        if (this.isDeclaration()) {
            this.typeName = string2;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isDeclaration() {
        return (this.mask & 1) != 0;
    }

    public boolean isClassMember() {
        return (this.mask & 4) != 0;
    }

    public boolean isIfaceMember() {
        return (this.mask & 2) != 0;
    }

    public boolean isStatic() {
        return (this.mask & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.mask & 0x10) != 0;
    }

    public boolean isPublic() {
        return (this.mask & 0x40) != 0;
    }

    public boolean isProtected() {
        return (this.mask & 0x20) != 0;
    }

    public boolean isPrivate() {
        return !this.isPublic() && !this.isProtected();
    }

    public boolean isFunction() {
        return (this.mask & 0x80) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isMethod() {
        return (this.mask & 0x80) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public boolean isVariable() {
        return (this.mask & 0x100) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isField() {
        return (this.mask & 0x100) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public boolean isClass() {
        return (this.mask & 0x400) != 0;
    }

    public boolean isConstant() {
        return (this.mask & 0x200) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isClassConstant() {
        return (this.mask & 0x200) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public String getSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(";");
        if (this.mask != 0) {
            stringBuilder.append(this.mask).append(";");
        } else assert (!this.isDeclaration());
        if (this.isDeclaration()) {
            stringBuilder.append(this.typeName).append(";");
        }
        return stringBuilder.toString();
    }

    public static IdentifierSignature createIdentifier(Identifier identifier) {
        String string = identifier.getName().toLowerCase();
        return new IdentifierSignature(string);
    }

    public static IdentifierSignature createDeclaration(Signature signature) {
        String string = signature.string(0);
        int n = signature.integer(1);
        String string2 = (n & 1) != 0 ? signature.string(2) : null;
        return new IdentifierSignature(string, string2, n);
    }

    public static IdentifierSignature createInvocation(Signature signature) {
        String string = signature.string(0);
        return new IdentifierSignature(string);
    }

    public static IdentifierSignature create(MethodScope methodScope) {
        return new IdentifierSignature(methodScope.getName(), methodScope.getPhpModifiers().toBitmask(), ElementKind.METHOD, methodScope.getInScope().getName(), true, methodScope.getInScope() instanceof ClassScope);
    }

    public static IdentifierSignature create(FieldElement fieldElement) {
        return new IdentifierSignature(fieldElement.getName(), fieldElement.getPhpModifiers().toBitmask(), ElementKind.FIELD, fieldElement.getInScope().getName(), true, fieldElement.getInScope() instanceof ClassScope);
    }

    public static IdentifierSignature create(ClassConstantElement classConstantElement) {
        return new IdentifierSignature(classConstantElement.getName(), classConstantElement.getPhpModifiers().toBitmask(), ElementKind.CONSTANT, classConstantElement.getInScope().getName(), true, classConstantElement.getInScope() instanceof ClassScope);
    }
}

