/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;

class CodeMarkerBuilder {
    private ASTNodeInfo currentNodeInfo;
    private Scope currentScope;
    private int offset;
    private Map<ASTNodeInfo<ReturnStatement>, Scope> returnStatements;
    private HashMap<MethodDeclarationInfo, Scope> methodDeclarations;
    private HashMap<FunctionDeclarationInfo, Scope> fncDeclarations;

    CodeMarkerBuilder(int n) {
        this.offset = n;
        this.returnStatements = new HashMap<ASTNodeInfo<ReturnStatement>, Scope>();
        this.methodDeclarations = new HashMap();
        this.fncDeclarations = new HashMap();
    }

    void prepare(FunctionDeclaration functionDeclaration, Scope scope) {
        FunctionDeclarationInfo functionDeclarationInfo = FunctionDeclarationInfo.create(functionDeclaration);
        if (this.canBePrepared(functionDeclaration, scope)) {
            this.fncDeclarations.put(functionDeclarationInfo, scope);
            this.setOccurenceAsCurrent(functionDeclarationInfo, scope);
        }
    }

    void prepare(MethodDeclaration methodDeclaration, Scope scope) {
        MethodDeclarationInfo methodDeclarationInfo = MethodDeclarationInfo.create(methodDeclaration);
        if (this.canBePrepared(methodDeclaration, scope)) {
            this.methodDeclarations.put(methodDeclarationInfo, scope);
            this.setOccurenceAsCurrent(methodDeclarationInfo, scope);
        }
    }

    void prepare(ReturnStatement returnStatement, Scope scope) {
        ASTNodeInfo<ReturnStatement> aSTNodeInfo = ASTNodeInfo.create(returnStatement);
        if (this.canBePrepared(returnStatement, scope)) {
            this.returnStatements.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo, scope);
        }
    }

    private void buildFunctionDeclarations(FileScopeImpl fileScopeImpl) {
        String string = this.currentScope.getName();
        for (Map.Entry<FunctionDeclarationInfo, Scope> entry : this.fncDeclarations.entrySet()) {
            Scope scope = entry.getValue();
            FunctionDeclarationInfo functionDeclarationInfo = entry.getKey();
            if (!string.equalsIgnoreCase(scope.getName())) continue;
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)functionDeclarationInfo.getOriginalNode();
            Identifier identifier = functionDeclaration.getFunctionName();
            OffsetRange offsetRange = new OffsetRange(functionDeclaration.getStartOffset(), identifier.getStartOffset());
            fileScopeImpl.addCodeMarker(new CodeMarkerImpl(scope, offsetRange, fileScopeImpl));
        }
    }

    private void buildMethodDeclarations(FileScopeImpl fileScopeImpl) {
        String string = this.currentScope.getName();
        for (Map.Entry<MethodDeclarationInfo, Scope> entry : this.methodDeclarations.entrySet()) {
            Scope scope = entry.getValue();
            Scope scope2 = scope.getInScope();
            Scope scope3 = this.currentScope.getInScope();
            MethodDeclarationInfo methodDeclarationInfo = entry.getKey();
            if (!string.equalsIgnoreCase(scope.getName()) || scope3 == null || scope2 == null || !scope3.getName().equalsIgnoreCase(scope2.getName())) continue;
            FunctionDeclaration functionDeclaration = ((MethodDeclaration)methodDeclarationInfo.getOriginalNode()).getFunction();
            Identifier identifier = functionDeclaration.getFunctionName();
            OffsetRange offsetRange = new OffsetRange(functionDeclaration.getStartOffset(), identifier.getStartOffset());
            fileScopeImpl.addCodeMarker(new CodeMarkerImpl(scope, offsetRange, fileScopeImpl));
        }
    }

    private void buildReturnStatement(FileScopeImpl fileScopeImpl) {
        String string = this.currentScope.getName();
        for (Map.Entry<ASTNodeInfo<ReturnStatement>, Scope> entry : this.returnStatements.entrySet()) {
            Scope scope = entry.getValue();
            Scope scope2 = scope.getInScope();
            Scope scope3 = this.currentScope.getInScope();
            ASTNodeInfo<ReturnStatement> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(scope.getName()) || scope3 == null || scope2 == null || !scope3.getName().equalsIgnoreCase(scope2.getName())) continue;
            fileScopeImpl.addCodeMarker(new CodeMarkerImpl(scope, aSTNodeInfo, fileScopeImpl));
        }
    }

    void build(FileScopeImpl fileScopeImpl) {
        if (this.currentNodeInfo != null && this.currentScope != null) {
            CodeMarkerImpl codeMarkerImpl = new CodeMarkerImpl(this.currentScope, this.currentNodeInfo, fileScopeImpl);
            ASTNodeInfo.Kind kind = this.currentNodeInfo.getKind();
            this.currentNodeInfo = null;
            switch (kind) {
                case FUNCTION: 
                case STATIC_METHOD: 
                case METHOD: 
                case RETURN_MARKER: {
                    this.buildMethodDeclarations(fileScopeImpl);
                    this.buildFunctionDeclarations(fileScopeImpl);
                    this.buildReturnStatement(fileScopeImpl);
                    break;
                }
                default: {
                    throw new IllegalStateException(kind.toString());
                }
            }
        }
    }

    private boolean canBePrepared(ASTNode aSTNode, ModelElement modelElement) {
        return this.getOffset() >= 0 && modelElement != null && aSTNode != null;
    }

    private void setOccurenceAsCurrent(ASTNodeInfo aSTNodeInfo, Scope scope) {
        OffsetRange offsetRange = aSTNodeInfo.getRange();
        Object t = aSTNodeInfo.getOriginalNode();
        if (t instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)t;
            Expression expression = returnStatement.getExpression();
            if (expression != null) {
                offsetRange = new OffsetRange(returnStatement.getStartOffset(), expression.getStartOffset());
            }
        } else if (t instanceof MethodDeclaration) {
            FunctionDeclaration functionDeclaration = ((MethodDeclaration)t).getFunction();
            Identifier identifier = functionDeclaration.getFunctionName();
            offsetRange = new OffsetRange(functionDeclaration.getStartOffset(), identifier.getStartOffset());
        } else if (t instanceof FunctionDeclaration) {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)t;
            Identifier identifier = functionDeclaration.getFunctionName();
            offsetRange = new OffsetRange(functionDeclaration.getStartOffset(), identifier.getStartOffset());
        }
        if (offsetRange.containsInclusive(this.getOffset())) {
            this.currentNodeInfo = aSTNodeInfo;
            this.currentScope = scope;
        }
    }

    int getOffset() {
        return this.offset;
    }
}

