/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldElementImpl
extends ScopeImpl
implements FieldElement {
    String defaultType;
    private String className;
    private static Set<String> recursionDetection = new HashSet<String>();

    FieldElementImpl(Scope scope, String string, SingleFieldDeclarationInfo singleFieldDeclarationInfo) {
        super(scope, singleFieldDeclarationInfo, singleFieldDeclarationInfo.getAccessModifiers(), null);
        this.defaultType = string;
        assert (scope instanceof TypeScope);
        this.className = scope.getName();
    }

    FieldElementImpl(Scope scope, String string, PhpDocTypeTagInfo phpDocTypeTagInfo) {
        super(scope, phpDocTypeTagInfo, phpDocTypeTagInfo.getAccessModifiers(), null);
        this.defaultType = string;
        assert (scope instanceof TypeScope);
        this.className = scope.getName();
    }

    FieldElementImpl(Scope scope, IndexedConstant indexedConstant) {
        super(scope, indexedConstant, PhpKind.FIELD);
        String string = indexedConstant.getIn();
        this.className = string != null ? string : scope.getName();
        this.defaultType = indexedConstant.getTypeName();
    }

    private FieldElementImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpModifiers phpModifiers, String string2) {
        super(scope, string, union2, offsetRange, PhpKind.FIELD, phpModifiers);
        this.defaultType = string2;
    }

    @Override
    void addElement(ModelElementImpl modelElementImpl) {
    }

    static String toName(SingleFieldDeclaration singleFieldDeclaration) {
        return VariableNameImpl.toName(singleFieldDeclaration.getName());
    }

    static OffsetRange toOffsetRange(SingleFieldDeclaration singleFieldDeclaration) {
        return VariableNameImpl.toOffsetRange(singleFieldDeclaration.getName());
    }

    static PhpModifiers toAccessModifiers(FieldsDeclaration fieldsDeclaration) {
        return new PhpModifiers(fieldsDeclaration.getModifier());
    }

    public Collection<? extends TypeScope> getDefaultTypes() {
        HashSet<? extends TypeScope> hashSet = new HashSet<TypeScope>();
        if (this.defaultType != null && this.defaultType.length() > 0) {
            String[] stringArray;
            for (String string : stringArray = this.defaultType.split("\\|")) {
                hashSet.addAll(CachingSupport.getTypes(string, this));
            }
        }
        return hashSet;
    }

    @Override
    public String getNormalizedName() {
        return this.className + super.getNormalizedName();
    }

    @Override
    public Collection<? extends String> getTypeNames(int n) {
        Collection<Object> collection;
        AssignmentImpl assignmentImpl = this.findAssignment(n);
        Collection<Object> collection2 = collection = assignmentImpl != null ? assignmentImpl.getTypeNames() : Collections.emptyList();
        if (collection.isEmpty() && (collection = this.getDefaultTypeNames()).isEmpty()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            for (VariableName variableName : classScope.getDeclaredVariables()) {
                if (!variableName.representsThis()) continue;
                return variableName.getTypeNames(n);
            }
        }
        return collection;
    }

    @Override
    public Collection<? extends TypeScope> getArrayAccessTypes(int n) {
        return this.getTypes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends TypeScope> getTypes(int n) {
        Collection<Object> collection;
        AssignmentImpl assignmentImpl = this.findAssignment(n);
        Collection<Object> collection2 = collection = assignmentImpl != null ? assignmentImpl.getTypes() : Collections.emptyList();
        if (collection.isEmpty() && (collection = this.getDefaultTypes()).isEmpty()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            for (VariableName variableName : classScope.getDeclaredVariables()) {
                if (!variableName.representsThis()) continue;
                String string = this.getNormalizedName();
                boolean bl = recursionDetection.add(string);
                try {
                    if (!bl) continue;
                    Collection<? extends TypeScope> collection3 = variableName.getFieldTypes(this, n);
                    return collection3;
                }
                finally {
                    recursionDetection.remove(string);
                }
            }
        }
        return collection;
    }

    @Override
    public Collection<? extends String> getDefaultTypeNames() {
        List list = Collections.emptyList();
        if (this.defaultType != null && this.defaultType.length() > 0) {
            list = new ArrayList();
            for (String string : this.defaultType.split("\\|")) {
                if (string.contains("@")) continue;
                list.add(string);
            }
        }
        return list;
    }

    public Collection<? extends FieldAssignmentImpl> getAssignments() {
        return FieldElementImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return true;
            }
        });
    }

    public AssignmentImpl findAssignment(int n) {
        FieldAssignmentImpl fieldAssignmentImpl = null;
        Collection<? extends FieldAssignmentImpl> collection = this.getAssignments();
        if (collection.size() == 1) {
            fieldAssignmentImpl = collection.iterator().next();
        } else {
            for (FieldAssignmentImpl fieldAssignmentImpl2 : collection) {
                if (!fieldAssignmentImpl2.getBlockRange().containsInclusive(n) || fieldAssignmentImpl != null && fieldAssignmentImpl.getOffset() > fieldAssignmentImpl2.getOffset() || fieldAssignmentImpl2.getOffset() >= n) continue;
                fieldAssignmentImpl = fieldAssignmentImpl2;
            }
        }
        return fieldAssignmentImpl;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getName().substring(1);
        stringBuilder.append(string.toLowerCase()).append(";");
        stringBuilder.append(string).append(";");
        stringBuilder.append(this.getOffset()).append(";");
        stringBuilder.append(this.getPhpModifiers().toBitmask()).append(";");
        if (this.defaultType != null) {
            stringBuilder.append(this.defaultType);
        }
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    @Override
    public Collection<? extends TypeScope> getFieldTypes(FieldElement fieldElement, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

