/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodScopeImpl
extends FunctionScopeImpl
implements MethodScope,
VariableNameFactory {
    private String classNormName;

    MethodScopeImpl(Scope scope, String string, MethodDeclarationInfo methodDeclarationInfo) {
        super(scope, methodDeclarationInfo, string);
        assert (scope instanceof TypeScope);
        this.classNormName = scope.getNormalizedName();
    }

    MethodScopeImpl(Scope scope, MagicMethodDeclarationInfo magicMethodDeclarationInfo) {
        super(scope, magicMethodDeclarationInfo);
        assert (scope instanceof TypeScope);
        this.classNormName = scope.getNormalizedName();
    }

    MethodScopeImpl(Scope scope, IndexedFunction indexedFunction) {
        super(scope, indexedFunction, PhpKind.METHOD);
        assert (scope instanceof TypeScope);
        this.classNormName = scope.getNormalizedName();
    }

    @Override
    public VariableNameImpl createElement(Variable variable) {
        VariableNameImpl variableNameImpl = new VariableNameImpl((Scope)this, variable, false);
        this.addElement(variableNameImpl);
        return variableNameImpl;
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        Scope scope = this.getInScope();
        if (scope instanceof ClassScope) {
            ClassScope classScope = (ClassScope)scope;
            return ModelUtils.merge(classScope.getDeclaredVariables(), super.getDeclaredVariables());
        }
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPhpModifiers().toString()).append(" ");
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    @Override
    public boolean isMagic() {
        return PredefinedSymbols.MAGIC_METHODS.containsKey(this.getName().toLowerCase());
    }

    @Override
    public boolean isConstructor() {
        return this.isMagic() ? this.getName().contains("__construct") : false;
    }

    @Override
    public TypeScope getTypeScope() {
        return (ClassScope)this.getInScope();
    }

    @Override
    public String getNormalizedName() {
        return this.classNormName + super.getNormalizedName();
    }

    @Override
    public String getClassSkeleton() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPhpModifiers().toString()).append(" ");
        stringBuilder.append("function").append(" ").append(this.getName());
        stringBuilder.append("(");
        List<? extends Parameter> list = this.getParameters();
        if (list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter;
                List<QualifiedName> list2;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if ((list2 = (parameter = list.get(i)).getTypes()).size() == 1) {
                    for (QualifiedName qualifiedName : list2) {
                        stringBuilder.append(qualifiedName.toString()).append(' ');
                    }
                }
                stringBuilder.append(parameter.getName());
                String string = parameter.getDefaultValue();
                if (string == null) continue;
                stringBuilder.append(" = ").append(string);
            }
        }
        stringBuilder.append(")");
        stringBuilder.append("{\n}");
        return stringBuilder.toString();
    }

    @Override
    public String getInterfaceSkeleton() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPhpModifiers().toString()).append(" ");
        stringBuilder.append("function").append(" ").append(this.getName());
        stringBuilder.append("(");
        List<? extends String> list = this.getParameterNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public String getIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName().toLowerCase()).append(";");
        stringBuilder.append(this.getName()).append(";");
        stringBuilder.append(this.getSignatureLastPart());
        return stringBuilder.toString();
    }

    @Override
    public String getConstructorIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getInScope().getName();
        stringBuilder.append(string.toLowerCase()).append(";");
        stringBuilder.append(string).append(";");
        stringBuilder.append(this.getSignatureLastPart());
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        stringBuilder.append(qualifiedName.toString()).append(";");
        return stringBuilder.toString();
    }

    private String getSignatureLastPart() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOffset()).append(";");
        List<? extends Parameter> list = this.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter = list.get(i);
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(parameter.getIndexSignature());
        }
        stringBuilder.append(";");
        if (this.returnType != null && !"mixed".equalsIgnoreCase(this.returnType)) {
            stringBuilder.append(this.returnType);
        }
        stringBuilder.append(";");
        stringBuilder.append(this.getPhpModifiers().toBitmask()).append(";");
        return stringBuilder.toString();
    }
}

