/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OccurenceImpl
implements Occurence {
    private OffsetRange occurenceRange;
    private ModelElement declaration;
    private Collection<? extends ModelElement> allDeclarations;
    private FileScopeImpl fileScope;
    private ModelElement gotDeclaration;

    public OccurenceImpl(Collection<? extends ModelElement> collection, OffsetRange offsetRange, FileScopeImpl fileScopeImpl) {
        this(collection, ModelUtils.getFirst(collection), offsetRange, fileScopeImpl);
    }

    public OccurenceImpl(Collection<? extends ModelElement> collection, ModelElement modelElement, OffsetRange offsetRange, FileScopeImpl fileScopeImpl) {
        this.allDeclarations = collection;
        this.declaration = modelElement;
        this.occurenceRange = offsetRange;
        this.fileScope = fileScopeImpl;
    }

    public OccurenceImpl(ModelElement modelElement, OffsetRange offsetRange, FileScopeImpl fileScopeImpl) {
        this.occurenceRange = offsetRange;
        this.declaration = modelElement;
        this.fileScope = fileScopeImpl;
    }

    public ModelElement geModelElement() {
        return this.declaration;
    }

    @Override
    public OffsetRange getOccurenceRange() {
        return this.occurenceRange;
    }

    public int getOffset() {
        return this.getOccurenceRange().getStart();
    }

    @Override
    public Collection<? extends ModelElement> getAllDeclarations() {
        if (this.gotDeclaration != null) {
            return Collections.emptyList();
        }
        if (this.allDeclarations == null) {
            this.allDeclarations = Collections.emptyList();
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this.geModelElement());
            switch (this.geModelElement().getPhpKind()) {
                case CONSTANT: {
                    this.allDeclarations = indexScopeImpl.findConstants(this.geModelElement().getName());
                    break;
                }
                case FUNCTION: {
                    this.allDeclarations = indexScopeImpl.findFunctions(this.geModelElement().getName());
                    break;
                }
                case CLASS: {
                    this.allDeclarations = indexScopeImpl.findClasses(this.geModelElement().getName());
                    break;
                }
                case IFACE: {
                    this.allDeclarations = indexScopeImpl.findInterfaces(this.geModelElement().getName());
                    break;
                }
                case METHOD: {
                    this.allDeclarations = indexScopeImpl.findMethods((TypeScope)((TypeScopeImpl)this.geModelElement().getInScope()), this.geModelElement().getName(), new int[0]);
                    break;
                }
                case FIELD: {
                    this.allDeclarations = indexScopeImpl.findFields((ClassScope)((ClassScopeImpl)this.geModelElement().getInScope()), this.geModelElement().getName(), new int[0]);
                    break;
                }
                case CLASS_CONSTANT: 
                case VARIABLE: 
                case INCLUDE: {
                    this.allDeclarations = Collections.singletonList(this.declaration);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.geModelElement().getPhpKind().toString());
                }
            }
        }
        return this.allDeclarations;
    }

    public List<Occurence> getAllOccurences() {
        return ModelVisitor.getAllOccurences(this.fileScope, this);
    }

    @Override
    public ModelElement getDeclaration() {
        return this.geModelElement();
    }

    public void setGotoDeclaration(ModelElement modelElement) {
        this.gotDeclaration = modelElement;
    }

    @Override
    public ModelElement gotoDeclaratin() {
        return this.gotDeclaration != null ? this.gotDeclaration : this.getDeclaration();
    }

    @Override
    public boolean gotoDeclarationEnabled() {
        return true;
    }
}

