/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypeScopeImpl
extends ScopeImpl
implements TypeScope {
    private Map<String, List<? extends InterfaceScope>> ifaces = new HashMap<String, List<? extends InterfaceScope>>();

    TypeScopeImpl(Scope scope, ClassDeclarationInfo classDeclarationInfo) {
        super(scope, classDeclarationInfo, classDeclarationInfo.getAccessModifiers(), ((ClassDeclaration)classDeclarationInfo.getOriginalNode()).getBody());
        List<? extends Expression> list = classDeclarationInfo.getInterfaces();
        for (Expression expression : list) {
            this.ifaces.put(CodeUtils.extractUnqualifiedName(expression), null);
        }
    }

    TypeScopeImpl(Scope scope, InterfaceDeclarationInfo interfaceDeclarationInfo) {
        super(scope, interfaceDeclarationInfo, new PhpModifiers(1), ((InterfaceDeclaration)interfaceDeclarationInfo.getOriginalNode()).getBody());
        List<? extends Expression> list = interfaceDeclarationInfo.getInterfaces();
        for (Expression expression : list) {
            this.ifaces.put(CodeUtils.extractUnqualifiedName(expression), null);
        }
    }

    protected TypeScopeImpl(Scope scope, IndexedClass indexedClass) {
        super(scope, indexedClass, PhpKind.CLASS);
    }

    protected TypeScopeImpl(Scope scope, IndexedInterface indexedInterface) {
        super(scope, indexedInterface, PhpKind.IFACE);
    }

    public List<? extends String> getSuperInterfaceNames() {
        if (this.indexedElement instanceof IndexedClass) {
            return ((IndexedClass)this.indexedElement).getInterfaces();
        }
        return new ArrayList<String>(this.ifaces.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<? extends InterfaceScope> getSuperInterfaces() {
        LinkedHashSet<InterfaceScope> linkedHashSet = new LinkedHashSet<InterfaceScope>();
        Set<Object> set = this.indexedElement instanceof IndexedClass ? new HashSet(this.getSuperInterfaceNames()) : this.ifaces.keySet();
        for (String string : set) {
            List<InterfaceScope> list = this.ifaces.get(string);
            if (list == null) {
                if (this.indexedElement == null) {
                    NamespaceScope namespaceScope = (NamespaceScope)this.getInScope();
                    NamespaceScopeImpl namespaceScopeImpl = (NamespaceScopeImpl)namespaceScope;
                    list = ModelUtils.filter(namespaceScopeImpl.getDeclaredInterfaces(), string);
                    linkedHashSet.addAll(list);
                    this.ifaces.put(string, list);
                    if (linkedHashSet.isEmpty() && namespaceScope instanceof NamespaceScopeImpl) {
                        IndexScope indexScope = ModelUtils.getIndexScope(namespaceScopeImpl);
                        if (indexScope == null) throw new UnsupportedOperationException();
                        List<? extends InterfaceScope> list2 = CachingSupport.getInterfaces(string, this);
                        this.ifaces.put(string, list2);
                        for (InterfaceScope interfaceScope : list2) {
                            linkedHashSet.add((InterfaceScopeImpl)interfaceScope);
                        }
                    }
                } else {
                    list = Collections.emptyList();
                }
            } else {
                linkedHashSet.addAll(list);
            }
            assert (list != null);
        }
        return new ArrayList(linkedHashSet);
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredMethods() {
        return this.getDeclaredMethodsImpl(new int[0]);
    }

    public Collection<? extends MethodScope> getDeclaredMethodsImpl(final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findMethods((TypeScope)this, "", nArray);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.METHOD) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends MethodScope> findDeclaredMethods(final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            QualifiedName qualifiedName = this.getNamespaceName().append(this.getName());
            NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(qualifiedName.toString());
            List<? extends MethodScope> list = indexScopeImpl.findMethods((TypeScope)this, string, nArray);
            return namespaceIndexFilter.filterModelElements(list, true);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.METHOD) && ModelElementImpl.nameKindMatch(modelElement.getName(), QuerySupport.Kind.EXACT, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends MethodScope> findDeclaredMethods(final QuerySupport.Kind kind, final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findMethods((TypeScope)this, kind, string, nArray);
        }
        if (kind.equals((Object)QuerySupport.Kind.REGEXP) || kind.equals((Object)QuerySupport.Kind.CASE_INSENSITIVE_REGEXP)) {
            final Pattern pattern = Pattern.compile(kind.equals((Object)QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) ? string.toLowerCase() : string);
            return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

                public boolean isAccepted(ModelElement modelElement) {
                    return modelElement.getPhpKind().equals((Object)PhpKind.METHOD) && ModelElementImpl.nameKindMatch(pattern, modelElement.getName()) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
                }
            });
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.METHOD) && ModelElementImpl.nameKindMatch(modelElement.getName(), kind, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public final Collection<? extends ClassConstantElement> getDeclaredConstants() {
        return this.findDeclaredConstants(new String[0]);
    }

    @Override
    public Collection<? extends ClassConstantElement> findDeclaredConstants(String ... stringArray) {
        return this.findDeclaredConstants(QuerySupport.Kind.EXACT, stringArray);
    }

    @Override
    public Collection<? extends ClassConstantElement> findDeclaredConstants(final QuerySupport.Kind kind, final String ... stringArray) {
        if (ModelUtils.getFileScope(this) == null) {
            String[] stringArray2;
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            if (stringArray == null) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = "";
            } else {
                stringArray2 = stringArray;
            }
            return indexScopeImpl.findClassConstants(this, stringArray2);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.CLASS_CONSTANT) && (stringArray.length == 0 || ModelElementImpl.nameKindMatch(modelElement.getName(), kind, stringArray));
            }
        });
    }

    @Override
    public final Collection<? extends ClassConstantElement> getInheritedConstants() {
        return this.findInheritedConstants("");
    }

    @Override
    public Collection<? extends ClassConstantElement> findInheritedConstants(String string) {
        ArrayList<ClassConstantElementImpl> arrayList = new ArrayList<ClassConstantElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        PHPIndex pHPIndex = indexScope.getIndex();
        Collection<IndexedConstant> collection = PHPIndex.toMembers(pHPIndex.getAllTypeConstants(null, this.getName(), string, QuerySupport.Kind.PREFIX));
        for (IndexedConstant indexedConstant : collection) {
            arrayList.add(new ClassConstantElementImpl((Scope)this, indexedConstant));
        }
        return arrayList;
    }

    public List<? extends MethodScope> findInheritedMethods(String string) {
        ArrayList<MethodScopeImpl> arrayList = new ArrayList<MethodScopeImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        PHPIndex pHPIndex = indexScope.getIndex();
        QuerySupport.Kind kind = "".equals(string) ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.EXACT;
        QualifiedName qualifiedName = this.getNamespaceName().append(this.getName());
        NamespaceIndexFilter<IndexedClassMember<IndexedFunction>> namespaceIndexFilter = new NamespaceIndexFilter<IndexedClassMember<IndexedFunction>>(qualifiedName.toString());
        Collection<IndexedClassMember<IndexedFunction>> collection = pHPIndex.getAllMethods(null, this.getName(), string, kind, 5);
        collection = namespaceIndexFilter.filter(collection, true);
        for (IndexedClassMember<IndexedFunction> indexedClassMember : collection) {
            FileObject fileObject;
            Object object;
            IndexedFunction indexedFunction = indexedClassMember.getMember();
            String string2 = indexedFunction.getIn();
            if (this.getName().equals(string2) && (object = indexedFunction.getFileObject()) == (fileObject = this.getFileObject())) continue;
            if (indexedClassMember.getType() instanceof IndexedClass) {
                object = new ClassScopeImpl(indexScope, (IndexedClass)indexedClassMember.getType());
                arrayList.add(new MethodScopeImpl((Scope)object, indexedFunction));
                continue;
            }
            if (!(indexedClassMember.getType() instanceof IndexedInterface)) continue;
            object = new InterfaceScopeImpl(indexScope, (IndexedInterface)indexedClassMember.getType());
            arrayList.add(new MethodScopeImpl((Scope)object, indexedFunction));
        }
        return arrayList;
    }

    @Override
    public String getNormalizedName() {
        StringBuilder stringBuilder = new StringBuilder();
        Collection collection = this.getSuperInterfaceNames();
        for (String string : collection) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString() + super.getNormalizedName();
    }
}

