/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.Collection;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInfo {
    private Scope scope;
    private Union2<ASTNodeInfo, ModelElement> element;

    public ElementInfo(ModelElement modelElement) {
        this.element = Union2.createSecond((Object)modelElement);
        this.scope = modelElement instanceof Scope ? (Scope)modelElement : modelElement.getInScope();
    }

    public ElementInfo(ASTNodeInfo aSTNodeInfo, ModelElement modelElement) {
        this.element = Union2.createFirst((Object)aSTNodeInfo);
        this.scope = modelElement instanceof Scope ? (Scope)modelElement : modelElement.getInScope();
    }

    public Scope getScope() {
        return this.scope;
    }

    public FileScope getFileScope() {
        return ModelUtils.getFileScope(this.scope);
    }

    public NamespaceScope getNamespaceScope() {
        return ModelUtils.getNamespaceScope(this.scope);
    }

    public QualifiedName getTypeQualifiedName() {
        ASTNodeInfo aSTNodeInfo = this.getNodeInfo();
        QualifiedName qualifiedName = null;
        if (aSTNodeInfo != null) {
            Object t = aSTNodeInfo.getOriginalNode();
            qualifiedName = t instanceof StaticDispatch ? ASTNodeInfo.toQualifiedName(t, true) : aSTNodeInfo.getQualifiedName();
        } else {
            ModelElement modelElement = this.getModelElemnt();
            QualifiedName qualifiedName2 = modelElement.getNamespaceName();
            Scope scope = modelElement.getInScope();
            qualifiedName = scope instanceof TypeScope ? qualifiedName2.append(scope.getName()) : qualifiedName2.append(modelElement.getName());
        }
        return qualifiedName;
    }

    public QualifiedName getQualifiedName() {
        ASTNodeInfo aSTNodeInfo = this.getNodeInfo();
        QualifiedName qualifiedName = null;
        if (aSTNodeInfo != null) {
            qualifiedName = aSTNodeInfo.getQualifiedName();
        } else {
            ModelElement modelElement = this.getModelElemnt();
            QualifiedName qualifiedName2 = modelElement.getNamespaceName();
            qualifiedName = qualifiedName2.append(modelElement.getName());
        }
        return qualifiedName;
    }

    public Collection<QualifiedName> getComposedNames() {
        return QualifiedName.getComposedNames(this.getQualifiedName(), this.getNamespaceScope());
    }

    public String getName() {
        ASTNodeInfo aSTNodeInfo = this.getNodeInfo();
        if (aSTNodeInfo != null) {
            return aSTNodeInfo.getName();
        }
        return this.getModelElemnt().getName();
    }

    public ASTNodeInfo.Kind getKind() {
        ASTNodeInfo aSTNodeInfo = this.getNodeInfo();
        if (aSTNodeInfo != null) {
            return aSTNodeInfo.getKind();
        }
        ASTNodeInfo.Kind kind = null;
        ModelElement modelElement = this.getModelElemnt();
        switch (modelElement.getPhpKind()) {
            case CLASS: {
                kind = ASTNodeInfo.Kind.CLASS;
                break;
            }
            case CLASS_CONSTANT: {
                kind = ASTNodeInfo.Kind.CLASS_CONSTANT;
                break;
            }
            case CONSTANT: {
                kind = ASTNodeInfo.Kind.CONSTANT;
                break;
            }
            case FIELD: {
                kind = ASTNodeInfo.Kind.FIELD;
                break;
            }
            case FUNCTION: {
                kind = ASTNodeInfo.Kind.FUNCTION;
                break;
            }
            case IFACE: {
                kind = ASTNodeInfo.Kind.IFACE;
                break;
            }
            case INCLUDE: {
                kind = ASTNodeInfo.Kind.INCLUDE;
                break;
            }
            case METHOD: {
                boolean bl = modelElement.getPhpModifiers().isStatic();
                kind = bl ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
                break;
            }
            case VARIABLE: {
                kind = ASTNodeInfo.Kind.VARIABLE;
            }
        }
        assert (kind != null);
        return kind;
    }

    public OffsetRange getRange() {
        ASTNodeInfo aSTNodeInfo = this.getNodeInfo();
        if (aSTNodeInfo != null) {
            return aSTNodeInfo.getRange();
        }
        return this.getModelElemnt().getNameRange();
    }

    public Union2<ASTNodeInfo, ModelElement> getRawElement() {
        return this.element;
    }

    private ASTNodeInfo getNodeInfo() {
        return this.element.hasFirst() ? (ASTNodeInfo)this.element.first() : null;
    }

    private ModelElement getModelElemnt() {
        return this.element.hasSecond() ? (ModelElement)this.element.second() : null;
    }
}

