/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFullyQualified;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUseImportRule
extends AbstractRule {
    public String getId() {
        return "AddUse.Import.Rule";
    }

    public String getDescription() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportRuleDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportRuleDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext pHPRuleContext, List<Hint> list, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult pHPParseResult = (PHPParseResult)pHPRuleContext.parserResult;
        if (pHPParseResult.getProgram() == null) {
            return;
        }
        BaseDocument baseDocument = pHPRuleContext.doc;
        int n = pHPRuleContext.caretOffset;
        int n2 = -1;
        int n3 = -1;
        n2 = n > 0 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)n) : -1;
        int n4 = n3 = n2 != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : -1;
        if (n2 != -1 && n3 != -1 && n > n2) {
            CheckVisitor checkVisitor = new CheckVisitor(pHPRuleContext, baseDocument, n2, n3);
            pHPParseResult.getProgram().accept(checkVisitor);
            list.addAll(checkVisitor.getHints());
        }
    }

    private static boolean isInside(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private static boolean isBefore(int n, int n2) {
        return n <= n2;
    }

    private static boolean isClassName(ASTNode aSTNode) {
        return aSTNode instanceof ClassName || aSTNode instanceof FormalParameter || aSTNode instanceof StaticConstantAccess || aSTNode instanceof StaticMethodInvocation || aSTNode instanceof StaticFieldAccess || aSTNode instanceof ClassDeclaration;
    }

    private static boolean isFunctionName(ASTNode aSTNode) {
        return aSTNode instanceof FunctionName;
    }

    class ChangeNameFix
    implements HintFix {
        private BaseDocument doc;
        private ASTNode node;
        private NamespaceScope scope;
        private QualifiedName newName;
        private QualifiedName oldName;

        public ChangeNameFix(BaseDocument baseDocument, ASTNode aSTNode, NamespaceScope namespaceScope, QualifiedName qualifiedName, QualifiedName qualifiedName2) {
            this.doc = baseDocument;
            this.newName = qualifiedName;
            this.oldName = qualifiedName2;
            this.scope = namespaceScope;
            this.node = aSTNode;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return NbBundle.getMessage(AddUseImportRule.class, (String)"ChangeNameFix_Description", (Object)this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, this.oldName.toString().length(), this.getGeneratedCode(), true, 0);
            editList.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)n));
        }

        private String getGeneratedCode() {
            return this.newName.toString();
        }

        private int getOffset() {
            return this.node.getStartOffset();
        }
    }

    class AddImportFix
    implements HintFix {
        private BaseDocument doc;
        private NamespaceScope scope;
        private QualifiedName importName;

        public AddImportFix(BaseDocument baseDocument, NamespaceScope namespaceScope, QualifiedName qualifiedName) {
            this.doc = baseDocument;
            this.importName = qualifiedName;
            this.scope = namespaceScope;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.getOffset(), this.getOffset() + this.getGeneratedCode().length());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportFix_Description", (Object)this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.getGeneratedCode(), true, 0);
            editList.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)this.getOffsetRange().getEnd()));
        }

        private String getGeneratedCode() {
            return "use " + this.importName.toString() + ";";
        }

        private int getOffset() {
            try {
                return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.getReferenceElement().getOffset());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return 0;
            }
        }

        private ModelElement getReferenceElement() {
            ModelElement modelElement = null;
            Collection<? extends UseElement> collection = this.scope.getDeclaredUses();
            for (UseElement useElement : collection) {
                if (modelElement != null && modelElement.getOffset() >= useElement.getOffset()) continue;
                modelElement = useElement;
            }
            return modelElement != null ? modelElement : this.scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private BaseDocument doc;
        private PHPRuleContext context;
        private Collection<Hint> hints = new ArrayList<Hint>();

        CheckVisitor(PHPRuleContext pHPRuleContext, BaseDocument baseDocument, int n, int n2) {
            this.doc = baseDocument;
            this.lineBegin = n;
            this.lineEnd = n2;
            this.context = pHPRuleContext;
        }

        public Collection<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void scan(ASTNode aSTNode) {
            if (aSTNode != null && AddUseImportRule.isBefore(aSTNode.getStartOffset(), this.lineEnd)) {
                super.scan(aSTNode);
            }
        }

        @Override
        public void visit(NamespaceName namespaceName) {
            if (AddUseImportRule.isInside(namespaceName.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Object object;
                List<ASTNode> list = this.getPath();
                ASTNode aSTNode = list.get(0);
                NamespaceDeclaration namespaceDeclaration = null;
                for (ASTNode object22 : list) {
                    if (!(object22 instanceof NamespaceDeclaration)) continue;
                    namespaceDeclaration = (NamespaceDeclaration)object22;
                }
                if (AddUseImportRule.isFunctionName(aSTNode)) {
                    object = QualifiedName.create(namespaceName);
                    if (!((QualifiedName)object).getKind().isFullyQualified()) {
                        Collection<IndexedFunction> collection = this.context.getIndex().getFunctions(null, ((QualifiedName)object).toName().toString(), QuerySupport.Kind.EXACT);
                        for (IndexedFunction indexedFunction : collection) {
                            this.addImportHints(indexedFunction, (QualifiedName)object, namespaceDeclaration, namespaceName);
                        }
                    }
                    super.visit(namespaceName);
                } else if (AddUseImportRule.isClassName(aSTNode)) {
                    object = QualifiedName.create(namespaceName);
                    if (!((QualifiedName)object).getKind().isFullyQualified()) {
                        Collection<IndexedClass> collection = this.context.getIndex().getClasses(null, ((QualifiedName)object).toName().toString(), QuerySupport.Kind.EXACT);
                        for (IndexedClass indexedClass : collection) {
                            this.addImportHints(indexedClass, (QualifiedName)object, namespaceDeclaration, namespaceName);
                        }
                    }
                    super.visit(namespaceName);
                } else {
                    object = QualifiedName.create(namespaceName);
                    if (!((QualifiedName)object).getKind().isFullyQualified()) {
                        Collection<IndexedConstant> collection = this.context.getIndex().getConstants(null, ((QualifiedName)object).toName().toString(), QuerySupport.Kind.EXACT);
                        for (IndexedConstant indexedConstant : collection) {
                            this.addImportHints(indexedConstant, (QualifiedName)object, namespaceDeclaration, namespaceName);
                        }
                    }
                    super.visit(namespaceName);
                }
            }
        }

        @Override
        public void visit(Scalar scalar) {
            if (AddUseImportRule.isInside(scalar.getStartOffset(), this.lineBegin, this.lineEnd)) {
                QualifiedName qualifiedName;
                List<ASTNode> list = this.getPath();
                NamespaceDeclaration namespaceDeclaration = null;
                for (ASTNode object2 : list) {
                    if (!(object2 instanceof NamespaceDeclaration)) continue;
                    namespaceDeclaration = (NamespaceDeclaration)object2;
                }
                String string = scalar.getStringValue();
                if (string != null && string.trim().length() > 0 && scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(string) && !(qualifiedName = QualifiedName.create(string)).getKind().isFullyQualified()) {
                    Collection<IndexedConstant> collection = this.context.getIndex().getConstants(null, qualifiedName.toName().toString(), QuerySupport.Kind.EXACT);
                    for (IndexedConstant indexedConstant : collection) {
                        this.addImportHints(indexedConstant, qualifiedName, namespaceDeclaration, scalar);
                    }
                }
            }
            super.visit(scalar);
        }

        private void addImportHints(IndexedFullyQualified indexedFullyQualified, QualifiedName qualifiedName, NamespaceDeclaration namespaceDeclaration, ASTNode aSTNode) {
            QualifiedName qualifiedName2 = indexedFullyQualified.getQualifiedName();
            QualifiedName qualifiedName3 = QualifiedName.getPrefix(qualifiedName2, qualifiedName, true);
            if (qualifiedName3 != null) {
                Collection<? extends UseElement> collection;
                List<UseElement> list;
                final String string = qualifiedName3.toString();
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(namespaceDeclaration, this.context.fileScope);
                if (!namespaceScope.getQualifiedName().append(qualifiedName).equals(qualifiedName2) && (list = ModelUtils.filter(collection = namespaceScope.getDeclaredUses(), new ModelUtils.ElementFilter<UseElement>(){

                    @Override
                    public boolean isAccepted(UseElement useElement) {
                        return useElement.getName().equalsIgnoreCase(string);
                    }
                })).isEmpty()) {
                    Object object;
                    if (indexedFullyQualified instanceof IndexedClass || !qualifiedName.getKind().isUnqualified()) {
                        object = new AddImportFix(this.doc, namespaceScope, qualifiedName3);
                        this.hints.add(new Hint((Rule)AddUseImportRule.this, ((AddImportFix)object).getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset()), Collections.singletonList(object), 500));
                    }
                    if ((object = QualifiedName.getPreferredName(qualifiedName2, namespaceScope)) != null) {
                        ChangeNameFix changeNameFix = new ChangeNameFix(this.doc, aSTNode, namespaceScope, (QualifiedName)object, qualifiedName);
                        this.hints.add(new Hint((Rule)AddUseImportRule.this, changeNameFix.getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset()), Collections.singletonList(changeNameFix), 500));
                    }
                }
            }
        }
    }
}

