/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.sql.execute.LogFileLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecutionInfo;
import org.netbeans.modules.db.api.sql.execute.StatementExecutionInfo;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;

public class SQLExecutor {
    private static Logger LOGGER = Logger.getLogger(SQLExecutor.class.getName());

    public static SQLExecutionInfo execute(DatabaseConnection databaseConnection, String string) throws DatabaseException {
        return SQLExecutor.execute(databaseConnection, string, new LogFileLogger());
    }

    public static SQLExecutionInfo execute(DatabaseConnection databaseConnection, String string, SQLExecuteLogger sQLExecuteLogger) throws DatabaseException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("You can not run this method on the event dispatching thread.");
        }
        if (sQLExecuteLogger == null) {
            throw new NullPointerException();
        }
        if (databaseConnection == null) {
            throw new IllegalArgumentException("The connection parameter cannot be null");
        }
        Connection connection = databaseConnection.getJDBCConnection(true);
        if (connection == null) {
            throw new DatabaseException("The connection is not open");
        }
        SQLExecutionResults sQLExecutionResults = SQLExecuteHelper.execute(string, 0, string.length(), databaseConnection, new LoggerProxy(sQLExecuteLogger));
        return new SQLExecutionInfoImpl(sQLExecutionResults);
    }

    private static class LoggerProxy
    implements SQLExecutionLogger {
        private final SQLExecuteLogger delegate;

        public LoggerProxy(SQLExecuteLogger sQLExecuteLogger) {
            this.delegate = sQLExecuteLogger;
        }

        public void log(SQLExecutionResult sQLExecutionResult) {
            this.delegate.log(new StatementExecutionInfoImpl(sQLExecutionResult));
        }

        public void finish(long l) {
            this.delegate.finish(l);
        }

        public void cancel() {
            this.delegate.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatementExecutionInfoImpl
    implements StatementExecutionInfo {
        private SQLExecutionResult result;

        public StatementExecutionInfoImpl(SQLExecutionResult sQLExecutionResult) {
            this.result = sQLExecutionResult;
        }

        @Override
        public String getSQL() {
            return this.result.getStatementInfo().getSQL();
        }

        @Override
        public boolean hasExceptions() {
            return this.result.hasExceptions();
        }

        @Override
        public Collection<Throwable> getExceptions() {
            return this.result.getExceptions();
        }

        @Override
        public long getExecutionTime() {
            return this.result.getExecutionTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SQLExecutionInfoImpl
    implements SQLExecutionInfo {
        private final boolean hasExceptions;
        private final List<Throwable> exceptions;
        private final List<StatementExecutionInfo> infos;

        SQLExecutionInfoImpl(SQLExecutionResults sQLExecutionResults) {
            this.hasExceptions = sQLExecutionResults.hasExceptions();
            this.exceptions = new ArrayList<Throwable>();
            this.infos = new ArrayList<StatementExecutionInfo>();
            for (SQLExecutionResult sQLExecutionResult : sQLExecutionResults.getResults()) {
                this.infos.add(new StatementExecutionInfoImpl(sQLExecutionResult));
                if (!sQLExecutionResult.hasExceptions()) continue;
                this.exceptions.addAll(sQLExecutionResult.getExceptions());
            }
        }

        @Override
        public boolean hasExceptions() {
            return this.hasExceptions;
        }

        @Override
        public List<? extends Throwable> getExceptions() {
            return this.exceptions;
        }

        @Override
        public List<StatementExecutionInfo> getStatementInfos() {
            return this.infos;
        }
    }
}

