/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.SimpleExtBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MacBrowserImpl
extends ExtBrowserImpl {
    public MacBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "MacBrowserImpl created from factory: " + extWebBrowser);
        }
    }

    public void setURL(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            uRL = URLUtil.createExternalURL(uRL, false);
            URI uRI = uRL.toURI();
            NbProcessDescriptor nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
            if (nbProcessDescriptor != null) {
                nbProcessDescriptor.exec((Format)((Object)new SimpleExtBrowser.BrowserFormat(uRI == null ? "" : uRI.toASCIIString())));
            }
            this.url = uRL;
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        catch (IOException iOException) {
            MacBrowserImpl.logInfo(iOException);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)MacBrowserImpl.class, (String)"EXC_Invalid_Processor"), -1, 2));
        }
    }

    private static void logInfo(Exception exception) {
        Logger logger = Logger.getLogger(MacBrowserImpl.class.getName());
        logger.log(Level.INFO, null, exception);
    }
}

