/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLResultParser;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.xml.sax.SAXException;

public final class BatchTest
extends BaseTest {
    private Project project;
    private Resources resources = new Resources();
    private boolean failedOnly = false;

    public BatchTest(Project project) {
        this.project = project;
    }

    public void setRerunfailed(boolean rerunFailed) {
        this.failedOnly = rerunFailed;
    }

    public void addFileSet(FileSet fs) {
        this.add((ResourceCollection)fs);
        if (fs.getProject() == null) {
            fs.setProject(this.project);
        }
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public Enumeration elements() {
        Object[] tests = this.createAllJUnitTest();
        return Enumerations.fromArray(tests);
    }

    void addTestsTo(Vector v) {
        JUnitTest[] tests = this.createAllJUnitTest();
        v.ensureCapacity(v.size() + tests.length);
        for (int i = 0; i < tests.length; ++i) {
            v.addElement(tests[i]);
        }
    }

    private JUnitTest[] createAllJUnitTest() {
        JUnitTest[] tests;
        String[] filenames = this.getFilenames();
        if (!this.failedOnly) {
            tests = new JUnitTest[filenames.length];
            for (int i = 0; i < tests.length; ++i) {
                String classname = BatchTest.javaToClass(filenames[i]);
                tests[i] = this.createJUnitTest(classname);
            }
        } else {
            ArrayList<JUnitTest> testsList = new ArrayList<JUnitTest>(10);
            block3: for (int i = 0; i < filenames.length; ++i) {
                List testListLines;
                String classname = BatchTest.javaToClass(filenames[i]);
                File resultsFile = this.getXMLResultsFile(classname);
                if (resultsFile == null || (testListLines = this.parseResultsFile(resultsFile)) == null || testListLines.isEmpty()) continue;
                int count = testListLines.size();
                for (int j = 0; j < count; ++j) {
                    JUnitTest test;
                    String line = (String)testListLines.get(j);
                    try {
                        test = this.parseTestListLine(line);
                    }
                    catch (IllegalArgumentException ex) {
                        this.project.log("File " + resultsFile + " contained invalid description of tests: " + ex.getMessage(), 1);
                        continue block3;
                    }
                    if (test == null) continue;
                    testsList.add(test);
                }
            }
            tests = !testsList.isEmpty() ? testsList.toArray(new JUnitTest[testsList.size()]) : new JUnitTest[]{};
        }
        return tests;
    }

    private File getXMLResultsFile(String testClassName) {
        File file = new File(this.getTodir(), "TEST-" + testClassName + ".xml");
        if (!file.isFile()) {
            this.project.log("XML results file " + file + " does not exist", 3);
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List parseResultsFile(File file) {
        List list;
        Reader reader;
        block12: {
            if (!file.canRead()) {
                this.project.log("Cannot read XML results file " + file, 1);
                return null;
            }
            this.project.log("Parsing file " + file, 3);
            reader = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            list = XMLResultParser.parseResultsFile(reader);
            Object var6_6 = null;
            if (reader == null) break block12;
            try {
                reader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return list;
        catch (IOException ex1) {
            List list2;
            block13: {
                this.project.log("Error while reading XML results file " + file, (Throwable)ex1, 0);
                list2 = null;
                Object var6_7 = null;
                if (reader == null) break block13;
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return list2;
        }
        catch (SAXException ex2) {
            List list3;
            block14: {
                this.project.log("Error while parsing XML results file " + file, (Throwable)ex2, 0);
                list3 = null;
                Object var6_8 = null;
                if (reader == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var6_9 = null;
                            if (reader == null) break block15;
                            try {
                                reader.close();
                            }
                            catch (IOException ex) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return list3;
        }
    }

    private JUnitTest parseTestListLine(String line) throws IllegalArgumentException {
        String methodsList;
        String className;
        int colonIndex = line.indexOf(58);
        if (colonIndex == -1) {
            className = line.trim();
            methodsList = null;
        } else {
            className = line.substring(0, colonIndex).trim();
            methodsList = line.substring(colonIndex + 1);
        }
        this.checkClassNameIsValid(className);
        if ("junit.framework.JUnit4TestCaseFacade".equals(className)) {
            return null;
        }
        if (methodsList == null) {
            return this.createJUnitTest(className);
        }
        String[] methods = JUnitTest.parseTestMethodNamesList(methodsList);
        return methods.length != 0 ? this.createJUnitTest(className, methods) : null;
    }

    private void checkClassNameIsValid(String className) throws IllegalArgumentException {
        String errMsg = "Invalid class name";
        int dotIndex = className.indexOf(46);
        if (dotIndex == -1) {
            BatchTest.checkJavaIdentifier(className, "Invalid class name");
        } else {
            int previousDotIndex = -1;
            do {
                BatchTest.checkJavaIdentifier(className.substring(previousDotIndex + 1, dotIndex), "Invalid class name");
            } while ((dotIndex = className.indexOf(46, (previousDotIndex = dotIndex) + 1)) != -1);
            BatchTest.checkJavaIdentifier(className.substring(previousDotIndex + 1), "Invalid class name");
        }
    }

    private static void checkJavaIdentifier(String name, String errMsg) throws IllegalArgumentException {
        int length = name.length();
        if (length == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException(errMsg + ": " + name);
        }
        if (length > 1) {
            char[] chars = name.substring(1).toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isJavaIdentifierPart(chars[i])) continue;
                throw new IllegalArgumentException(errMsg + ": " + name);
            }
        }
    }

    private String[] getFilenames() {
        Vector<String> v = new Vector<String>();
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            Resource r = (Resource)iter.next();
            if (!r.isExists()) continue;
            String pathname = r.getName();
            if (pathname.endsWith(".java")) {
                v.addElement(pathname.substring(0, pathname.length() - ".java".length()));
                continue;
            }
            if (!pathname.endsWith(".class")) continue;
            v.addElement(pathname.substring(0, pathname.length() - ".class".length()));
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public static String javaToClass(String filename) {
        return filename.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.');
    }

    private JUnitTest createJUnitTest(String classname) {
        return this.createJUnitTest(classname, null);
    }

    private JUnitTest createJUnitTest(String classname, String[] methods) {
        JUnitTest test = new JUnitTest();
        test.setName(classname);
        test.setMethods(methods);
        test.setHaltonerror(this.haltOnError);
        test.setHaltonfailure(this.haltOnFail);
        test.setFiltertrace(this.filtertrace);
        test.setFork(this.fork);
        test.setIf(this.ifProperty);
        test.setUnless(this.unlessProperty);
        test.setTodir(this.destDir);
        test.setFailureProperty(this.failureProperty);
        test.setErrorProperty(this.errorProperty);
        Enumeration list = this.formatters.elements();
        while (list.hasMoreElements()) {
            test.addFormatter((FormatterElement)list.nextElement());
        }
        return test;
    }
}

