/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeErrorProvider
extends CsmErrorProvider {
    public String getName() {
        return "include-errors";
    }

    private static final String decorateWithExtraHyperlinkTip(String string) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
        int n = preferences.getInt("alt-hyperlink-activation-modifiers", 640);
        return NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_HyperlinkActionsHints", (Object)string, (Object)InputEvent.getModifiersExText(n));
    }

    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile csmFile = request.getFile();
        for (Object object : CsmFileInfoQuery.getDefault().getBrokenIncludes(csmFile)) {
            if (request.isCancelled()) break;
            if (object.getIncludeFile() != null) continue;
            response.addError((CsmErrorInfo)new IncludeErrorInfo((CsmInclude)object));
        }
        for (Object object : csmFile.getErrors()) {
            response.addError((CsmErrorInfo)new ErrorDirectiveInfo((CsmErrorDirective)object));
        }
        HashSet hashSet = new HashSet();
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null || !this.hasBrokenIncludes(csmFile2, hashSet)) continue;
            response.addError((CsmErrorInfo)new IncludeWarningInfo(csmInclude));
        }
    }

    private boolean hasBrokenIncludes(CsmFile csmFile, Collection<CsmFile> collection) {
        if (collection.contains(csmFile)) {
            return false;
        }
        collection.add(csmFile);
        if (CsmFileInfoQuery.getDefault().hasBrokenIncludes(csmFile)) {
            return true;
        }
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null || !this.hasBrokenIncludes(csmFile2, collection)) continue;
            return true;
        }
        return false;
    }

    private static final class ErrorDirectiveInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message = NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_ErrorDirective");

        public ErrorDirectiveInfo(CsmErrorDirective csmErrorDirective) {
            super((CsmOffsetable)csmErrorDirective, CsmErrorInfo.Severity.ERROR);
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static final class IncludeWarningInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeWarningInfo(CsmInclude csmInclude) {
            super((CsmOffsetable)csmInclude, CsmErrorInfo.Severity.WARNING);
            this.message = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissedWarning", (Object)IncludeWarningInfo.getIncludeText(csmInclude)));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude csmInclude) {
            if (csmInclude.isSystem()) {
                return "<" + csmInclude.getIncludeName() + ">";
            }
            return "\"" + csmInclude.getIncludeName() + "\"";
        }
    }

    private static final class IncludeErrorInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeErrorInfo(CsmInclude csmInclude) {
            super((CsmOffsetable)csmInclude, CsmErrorInfo.Severity.ERROR);
            this.message = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissed", (Object)IncludeErrorInfo.getIncludeText(csmInclude)));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude csmInclude) {
            if (csmInclude.isSystem()) {
                return "<" + csmInclude.getIncludeName() + ">";
            }
            return "\"" + csmInclude.getIncludeName() + "\"";
        }
    }

    private static abstract class OffsetableErrorInfo
    implements CsmErrorInfo {
        private int start;
        private int end;
        private CsmErrorInfo.Severity severity;

        public OffsetableErrorInfo(CsmOffsetable csmOffsetable, CsmErrorInfo.Severity severity) {
            this.start = csmOffsetable.getStartOffset();
            this.end = csmOffsetable.getEndOffset();
            this.severity = severity;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }
    }
}

