/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoveAction
extends AbstractAction
implements ActionContext {
    public static final String DISPLAY_NAME_MOVE_UP = NbBundle.getMessage(MoveAction.class, (String)"NAME_MoveUpAction");
    public static final String DISPLAY_NAME_MOVE_DOWN = NbBundle.getMessage(MoveAction.class, (String)"NAME_MoveDownAction");
    public static final String PROPERTY_NAME_REFERENCE = "propertyName";
    private WeakReference<DesignComponent> component;
    private boolean isEnabled;
    private String arrayPropertyName;
    private TypeID newArrayTypeID;

    public static final Action createMoveUpAction(String string) {
        return new MoveAction(string, DISPLAY_NAME_MOVE_UP){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control U"));
            }

            @Override
            protected void invokeMoveAction(List<PropertyValue> list, List<PropertyValue> list2, PropertyValue propertyValue) {
                int n = list.indexOf(propertyValue);
                if (n != 0) {
                    list2.remove(propertyValue);
                    list2.add(n - 1, propertyValue);
                    this.saveToModel(list2);
                }
            }
        };
    }

    public static final Action createMoveDownAction(String string) {
        return new MoveAction(string, DISPLAY_NAME_MOVE_DOWN){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
            }

            @Override
            protected void invokeMoveAction(List<PropertyValue> list, List<PropertyValue> list2, PropertyValue propertyValue) {
                int n = list.indexOf(propertyValue);
                int n2 = list.size() - n;
                if (n2 > 1) {
                    list2.remove(propertyValue);
                    list2.add(n + 1, propertyValue);
                    this.saveToModel(list2);
                }
            }
        };
    }

    private MoveAction(String string, String string2) {
        this.putValue("Name", string2);
        this.arrayPropertyName = string;
    }

    protected DesignComponent getComponent() {
        return (DesignComponent)this.component.get();
    }

    @Override
    public boolean isEnabled() {
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (((DesignComponent)MoveAction.this.component.get()).getDocument().getSelectedComponents().size() > 1) {
                    MoveAction.this.isEnabled = false;
                } else {
                    MoveAction.this.isEnabled = true;
                }
            }
        });
        return this.isEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                PropertyValue propertyValue = MoveAction.this.getComponent().getParentComponent().readProperty(MoveAction.this.getArrayPropertyName());
                List<PropertyValue> list = propertyValue.getArray();
                MoveAction.this.newArrayTypeID = propertyValue.getType().getComponentType();
                if (list.size() < 1) {
                    return;
                }
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(list);
                for (PropertyValue propertyValue2 : list) {
                    if (propertyValue2.getComponent() != MoveAction.this.getComponent()) continue;
                    MoveAction.this.invokeMoveAction(list, arrayList, propertyValue2);
                }
            }
        });
    }

    protected abstract void invokeMoveAction(List<PropertyValue> var1, List<PropertyValue> var2, PropertyValue var3);

    protected TypeID getNewArrayType() {
        return this.newArrayTypeID;
    }

    @Override
    public void setComponent(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
    }

    private String getArrayPropertyName() {
        return this.arrayPropertyName;
    }

    protected void saveToModel(List<PropertyValue> list) {
        DesignComponent designComponent = this.getComponent().getParentComponent();
        designComponent.writeProperty(this.getArrayPropertyName(), PropertyValue.createArray(this.getNewArrayType(), list));
    }
}

