/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.ReleaseVersionErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseVersionError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("ReleaseVersionError", NbBundle.getMessage(ReleaseVersionError.class, (String)"TIT_ReleaseLatestVersion"), NbBundle.getMessage(ReleaseVersionError.class, (String)"DESC_ReleaseLatestVersion"), true, Configuration.HintSeverity.WARNING);
    static final String PROP_RELEASE = "release";
    static final String PROP_LATEST = "latest";
    static final String PROP_SNAPSHOT = "snapshot";

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel pOMModel, Project project) {
        List list;
        assert (pOMModel != null);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        boolean bl = this.getConfiguration().getPreferences().getBoolean(PROP_RELEASE, true);
        boolean bl2 = this.getConfiguration().getPreferences().getBoolean(PROP_LATEST, true);
        boolean bl3 = this.getConfiguration().getPreferences().getBoolean(PROP_SNAPSHOT, false);
        Build build = pOMModel.getProject().getBuild();
        if (build != null) {
            this.checkPluginList(build.getPlugins(), pOMModel, arrayList, bl, bl2, bl3);
            list = build.getPluginManagement();
            if (list != null) {
                this.checkPluginList(list.getPlugins(), pOMModel, arrayList, bl, bl2, bl3);
            }
        }
        if ((list = pOMModel.getProject().getProfiles()) != null) {
            for (Profile profile : list) {
                BuildBase buildBase = profile.getBuildBase();
                if (buildBase == null) continue;
                this.checkPluginList(buildBase.getPlugins(), pOMModel, arrayList, bl, bl2, bl3);
                PluginManagement pluginManagement = buildBase.getPluginManagement();
                if (pluginManagement == null) continue;
                this.checkPluginList(pluginManagement.getPlugins(), pOMModel, arrayList, bl, bl2, bl3);
            }
        }
        return arrayList;
    }

    private void checkPluginList(List<Plugin> list, POMModel pOMModel, List<ErrorDescription> list2, boolean bl, boolean bl2, boolean bl3) {
        if (list != null) {
            for (Plugin plugin : list) {
                String string = plugin.getVersion();
                if (string == null || !(bl && "RELEASE".equals(string) || bl2 && "LATEST".equals(string)) && (!bl3 || !string.endsWith("SNAPSHOT"))) continue;
                int n = plugin.findChildElementPosition(pOMModel.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)pOMModel.getBaseDocument(), (int)n, (boolean)false);
                list2.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(ReleaseVersionError.class, (String)"DESC_RELEASE_VERSION"), Collections.emptyList(), (Document)pOMModel.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new ReleaseVersionErrorCustomizer(preferences);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

