/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom.spi;

import java.util.prefs.Preferences;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbPreferences;

public final class Configuration {
    private String id;
    private String description;
    private boolean defaultEnabled;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private HintSeverity defaultSeverity;
    private String displayName;

    public Configuration(String string, String string2, String string3, boolean bl, HintSeverity hintSeverity) {
        this.id = string;
        this.description = string3;
        this.defaultEnabled = bl;
        this.defaultSeverity = hintSeverity;
        this.displayName = string2;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass()).node(this.getId());
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isEnabled(Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, this.defaultEnabled);
    }

    public void setEnabled(Preferences preferences, boolean bl) {
        preferences.putBoolean(ENABLED_KEY, bl);
    }

    public final HintSeverity getSeverity(Preferences preferences) {
        String string = preferences.get(SEVERITY_KEY, null);
        return string == null ? this.defaultSeverity : Configuration.fromPreferenceString(string);
    }

    public void setSeverity(Preferences preferences, HintSeverity hintSeverity) {
        preferences.put(SEVERITY_KEY, hintSeverity.toPreferenceString());
    }

    public static HintSeverity fromPreferenceString(String string) {
        if (string.equals("error")) {
            return HintSeverity.ERROR;
        }
        if (string.equals("warning")) {
            return HintSeverity.WARNING;
        }
        throw new IllegalStateException(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HintSeverity {
        ERROR,
        WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
            }
            return null;
        }

        public String toPreferenceString() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
            }
            return null;
        }
    }
}

