/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.FileUtils;

public class TempFileDeleter {
    private static final ReferenceQueue QUEUE = new ReferenceQueue();
    private static final HashMap REF_MAP = new HashMap();

    private TempFileDeleter() {
    }

    public static synchronized Reference addFile(String string, Object object) {
        FileUtils.trace("TempFileDeleter.addFile", string, object);
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, QUEUE);
        TempFile tempFile = new TempFile();
        tempFile.fileName = string;
        tempFile.lastModified = FileUtils.getLastModified(string);
        REF_MAP.put(phantomReference, tempFile);
        TempFileDeleter.deleteUnused();
        return phantomReference;
    }

    public static synchronized void updateAutoDelete(Reference reference) {
        TempFile tempFile = (TempFile)REF_MAP.get(reference);
        if (tempFile != null) {
            long l;
            String string = tempFile.fileName;
            tempFile.lastModified = l = FileUtils.getLastModified(string);
        }
    }

    public static synchronized void deleteFile(Reference reference, String string) {
        TempFile tempFile;
        if (reference != null && (tempFile = (TempFile)REF_MAP.remove(reference)) != null) {
            if (SysProperties.CHECK && string != null && !tempFile.fileName.equals(string)) {
                throw Message.getInternalError("f2:" + tempFile.fileName + " f:" + string);
            }
            string = tempFile.fileName;
            long l = FileUtils.getLastModified(string);
            if (l != tempFile.lastModified) {
                return;
            }
        }
        if (string != null && FileUtils.exists(string)) {
            try {
                FileUtils.trace("TempFileDeleter.deleteFile", string, null);
                FileUtils.tryDelete(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteUnused() {
        Reference reference;
        while (QUEUE != null && (reference = QUEUE.poll()) != null) {
            TempFileDeleter.deleteFile(reference, null);
        }
    }

    public static void stopAutoDelete(Reference reference, String string) {
        FileUtils.trace("TempFileDeleter.stopAutoDelete", string, reference);
        if (reference != null) {
            TempFile tempFile = (TempFile)REF_MAP.remove(reference);
            if (SysProperties.CHECK && (tempFile == null || !tempFile.fileName.equals(string))) {
                throw Message.getInternalError("f2:" + tempFile + " " + (tempFile == null ? "" : tempFile.fileName) + " f:" + string);
            }
        }
        TempFileDeleter.deleteUnused();
    }

    static class TempFile {
        String fileName;
        long lastModified;

        TempFile() {
        }
    }
}

