/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JspPaletteUtilities {
    public static final String CARET = "&CARET&";
    private static final String JSTL_PREFIX = "c";
    private static final String JSTL_URI = "http://java.sun.com/jsp/jstl/core";
    private static final String SQL_PREFIX = "sql";
    private static final String SQL_URI = "http://java.sun.com/jsp/jstl/sql";

    public static void insert(String string, JTextComponent jTextComponent) throws BadLocationException {
        JspPaletteUtilities.insert(string, jTextComponent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String string, JTextComponent jTextComponent, boolean bl) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        if (document == null || !(document instanceof BaseDocument)) {
            return;
        }
        if (string == null) {
            string = "";
        }
        BaseDocument baseDocument = (BaseDocument)document;
        Indent indent = Indent.get((Document)baseDocument);
        indent.lock();
        try {
            baseDocument.atomicLock();
            try {
                int n = string.indexOf(CARET);
                if (n != -1) {
                    string = string.replace(CARET, "");
                }
                int n2 = JspPaletteUtilities.insert(string, jTextComponent, document);
                if (n != -1) {
                    jTextComponent.setCaretPosition(n2 + n);
                }
                if (bl && n2 >= 0 && document instanceof BaseDocument) {
                    int n3 = n2 + string.length();
                    indent.reindent(n2, n3);
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        finally {
            indent.unlock();
        }
    }

    private static FileObject getFileObject(JTextComponent jTextComponent) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        FileObject fileObject = dataObject != null ? NbEditorUtilities.getDataObject((Document)baseDocument).getPrimaryFile() : null;
        return fileObject;
    }

    private static int insert(String string, JTextComponent jTextComponent, Document document) throws BadLocationException {
        int n = -1;
        try {
            Caret caret = jTextComponent.getCaret();
            int n2 = Math.min(caret.getDot(), caret.getMark());
            int n3 = Math.max(caret.getDot(), caret.getMark());
            document.remove(n2, n3 - n2);
            n = caret.getDot();
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return n;
    }

    public static PageInfo.BeanData[] getAllBeans(JTextComponent jTextComponent) {
        JspParserAPI.ParseResult parseResult;
        FileObject fileObject = JspPaletteUtilities.getFileObject(jTextComponent);
        if (fileObject != null && (parseResult = JspContextInfo.getContextInfo((FileObject)fileObject).getCachedParseResult(fileObject, false, true)) != null && parseResult.getPageInfo() != null) {
            return parseResult.getPageInfo().getBeans();
        }
        return null;
    }

    public static boolean idExists(String string, PageInfo.BeanData[] beanDataArray) {
        boolean bl = false;
        if (string != null && beanDataArray != null) {
            for (int i = 0; i < beanDataArray.length; ++i) {
                PageInfo.BeanData beanData = beanDataArray[i];
                if (!beanData.getId().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean typeExists(JTextComponent jTextComponent, final String string) {
        final boolean[] blArray = new boolean[]{false};
        if (string != null) {
            JspPaletteUtilities.runUserActionTask(jTextComponent, new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    blArray[0] = compilationController.getElements().getTypeElement(string) != null;
                }
            });
        }
        return blArray[0];
    }

    private static void runUserActionTask(JTextComponent jTextComponent, Task<CompilationController> task) {
        FileObject fileObject = JspPaletteUtilities.getFileObject(jTextComponent);
        if (fileObject == null) {
            return;
        }
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fileObject), (FileObject[])new FileObject[0]);
            if (javaSource != null) {
                javaSource.runUserActionTask(task, false);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static List<String> getTypeProperties(JTextComponent jTextComponent, final String string, final String[] stringArray) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            JspPaletteUtilities.runUserActionTask(jTextComponent, new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                        for (ExecutableElement executableElement : list) {
                            String string3;
                            String string2 = executableElement.getSimpleName().toString();
                            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !this.match(string2, stringArray) || (string3 = this.extractPropName(string2, stringArray)) == null) continue;
                            arrayList.add(string3);
                        }
                    }
                }

                private String extractPropName(String string4, String[] stringArray2) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string2;
                        String string3 = stringArray2[i];
                        if (!string4.startsWith(string3) || (string2 = string4.substring(string3.length())).length() <= 0) continue;
                        return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
                    }
                    return null;
                }

                private boolean match(String string3, String[] stringArray2) {
                    boolean bl = false;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string2 = stringArray2[i];
                        if (!string3.startsWith(string2)) continue;
                        bl = true;
                        break;
                    }
                    return bl;
                }
            });
        }
        return arrayList;
    }

    public static String getTagLibPrefix(JTextComponent jTextComponent, String string) {
        JspParserAPI.ParseResult parseResult;
        FileObject fileObject = JspPaletteUtilities.getFileObject(jTextComponent);
        if (fileObject != null && (parseResult = JspContextInfo.getContextInfo((FileObject)fileObject).getCachedParseResult(fileObject, false, true)) != null && parseResult.getPageInfo() != null) {
            for (TagLibraryInfo tagLibraryInfo : parseResult.getPageInfo().getTaglibs()) {
                if (!string.equals(tagLibraryInfo.getURI())) continue;
                return tagLibraryInfo.getPrefixString();
            }
        }
        return null;
    }

    public static String findJstlPrefix(JTextComponent jTextComponent) {
        String string = JspPaletteUtilities.getTagLibPrefix(jTextComponent, JSTL_URI);
        if (string == null) {
            JspPaletteUtilities.insertTagLibRef(jTextComponent, JSTL_PREFIX, JSTL_URI);
        }
        return string != null ? string : JSTL_PREFIX;
    }

    public static String findSqlPrefix(JTextComponent jTextComponent) {
        String string = JspPaletteUtilities.getTagLibPrefix(jTextComponent, SQL_URI);
        if (string == null) {
            JspPaletteUtilities.insertTagLibRef(jTextComponent, SQL_PREFIX, SQL_URI);
        }
        return string != null ? string : SQL_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTagLibRef(JTextComponent jTextComponent, String string, String string2) {
        Document document = jTextComponent.getDocument();
        if (document != null && document instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)document;
            baseDocument.atomicLock();
            try {
                String string3;
                int n;
                String string4;
                int n2;
                int n3 = 0;
                String string5 = "<%@taglib prefix=\"" + string + "\" uri=\"" + string2 + "\"%>\n";
                FileObject fileObject = JspPaletteUtilities.getFileObject(jTextComponent);
                if (fileObject != null && "jspx".equals(fileObject.getExt()) && (n2 = (string4 = baseDocument.getText(0, n = baseDocument.getLength())).indexOf(string3 = "<jsp:root ")) != -1) {
                    n3 = n2 + string3.length();
                    string5 = "xmlns:" + string + "=\"" + string2 + "\" ";
                }
                document.insertString(n3, string5, null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }
}

