/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.InitParamPanel;
import org.netbeans.modules.web.wizards.MappingPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class DeployDataPanel
extends BaseWizardPanel
implements ItemListener {
    private TargetEvaluator evaluator = null;
    private ServletData deployData;
    private FileType fileType;
    private boolean edited = false;
    private TemplateWizard wizard;
    private JPanel myDescriptorCheckBoxPanel;
    private JCheckBox jCBservlet;
    private JTextField jTFclassname;
    private JTextField jTFname;
    private JTextField jTFmapping;
    private JLabel jLinstruction;
    private JLabel jLclassname;
    private JLabel jLname;
    private JLabel jLmapping;
    private InitParamPanel paramPanel;
    private MappingPanel mappingPanel;
    private static final long serialVersionUID = -2704206901170711687L;

    public DeployDataPanel(TargetEvaluator targetEvaluator, TemplateWizard templateWizard) {
        this.evaluator = targetEvaluator;
        this.wizard = templateWizard;
        this.fileType = this.evaluator.getFileType();
        this.deployData = (ServletData)this.evaluator.getDeployData();
        this.setName(NbBundle.getMessage(DeployDataPanel.class, (String)("TITLE_ddpanel_" + this.fileType)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_deployment"));
        this.initComponents();
        if (!Utilities.isJavaEE6(templateWizard)) {
            this.myDescriptorCheckBoxPanel.remove(this.jCBservlet);
        }
        this.fireChangeEvent();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(450, 250));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 7;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = -1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridwidth = 5;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = -1;
        gridBagConstraints5.gridwidth = 8;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.insets = new Insets(4, 20, 4, 0);
        this.jLinstruction = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_dd_" + this.fileType)));
        this.add((Component)this.jLinstruction, gridBagConstraints);
        ++gridBagConstraints3.gridy;
        this.myDescriptorCheckBoxPanel = new JPanel();
        this.myDescriptorCheckBoxPanel.setLayout(new FlowLayout(0, 0, 0));
        this.jCBservlet = new JCheckBox(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_addtodd"), true);
        this.jCBservlet.setMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_add_mnemonic").charAt(0));
        this.jCBservlet.addItemListener(this);
        this.jCBservlet.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_addtodd"));
        this.myDescriptorCheckBoxPanel.add(this.jCBservlet);
        this.add((Component)this.myDescriptorCheckBoxPanel, gridBagConstraints);
        ++gridBagConstraints3.gridy;
        this.jTFclassname = new JTextField(25);
        this.jTFclassname.setEnabled(false);
        this.jTFclassname.setBackground(this.getBackground());
        this.jLclassname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_ClassName"));
        this.jLclassname.setLabelFor(this.jTFclassname);
        this.jLclassname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_Class_Mnemonic").charAt(0));
        this.jTFclassname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_ClassName"));
        this.add((Component)this.jLclassname, gridBagConstraints2);
        this.add((Component)this.jTFclassname, gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        this.jTFname = new JTextField(25);
        this.jTFname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)("ACSD_name_" + this.fileType)));
        this.jTFname.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        DeployDataPanel.this.deployData.setName(DeployDataPanel.this.jTFname.getText().trim());
                        if (DeployDataPanel.this.fileType == FileType.FILTER) {
                            DeployDataPanel.this.mappingPanel.setData();
                        }
                        DeployDataPanel.this.fireChangeEvent();
                    }
                });
            }
        });
        this.jTFname.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.jTFname.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DeployDataPanel.this.jTFname.selectAll();
            }
        });
        this.jLname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_name_" + this.fileType)));
        this.jLname.setLabelFor(this.jTFname);
        this.jLname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_name_" + this.fileType + "_mnem")).charAt(0));
        this.add((Component)this.jLname, gridBagConstraints2);
        this.add((Component)this.jTFname, gridBagConstraints3);
        if (this.fileType == FileType.SERVLET) {
            ++gridBagConstraints3.gridy;
            this.jTFmapping = new JTextField(25);
            this.jTFmapping.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_url_mapping"));
            this.jTFmapping.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                            DeployDataPanel.this.fireChangeEvent();
                        }
                    });
                }
            });
            this.jTFmapping.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.jTFmapping.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    DeployDataPanel.this.jTFmapping.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                    DeployDataPanel.this.fireChangeEvent();
                }
            });
            this.jLmapping = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_url_mapping"));
            this.jLmapping.setLabelFor(this.jTFmapping);
            this.jLmapping.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_mapping_mnemonic").charAt(0));
            this.add((Component)this.jLmapping, gridBagConstraints2);
            this.add((Component)this.jTFmapping, gridBagConstraints3);
        }
        if (this.fileType == FileType.SERVLET) {
            this.paramPanel = new InitParamPanel(this.deployData, this, this.wizard);
            this.add((Component)this.paramPanel, gridBagConstraints5);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel = new MappingPanel(this.deployData, this, this.wizard);
            this.add((Component)this.mappingPanel, gridBagConstraints5);
        }
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = -1;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints6);
    }

    void setData() {
        String string = null;
        DataObject dataObject = this.wizard.getTemplate();
        string = dataObject.getNodeDelegate().getDisplayName();
        this.wizard.putProperty("NewFileWizard_Title", (Object)string);
        this.deployData.setClassName(this.evaluator.getClassName());
        this.jTFclassname.setText(this.deployData.getClassName());
        if (!this.edited) {
            this.deployData.setName(this.evaluator.getFileName());
            if (this.fileType == FileType.SERVLET) {
                this.deployData.parseUrlMappingString("/" + ServletData.getRFC2396URI(this.evaluator.getFileName()));
            }
        }
        this.jTFname.setText(this.deployData.getName());
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setText(this.deployData.getUrlMappingsAsString());
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setData();
        }
        if (Utilities.isJavaEE6(this.wizard)) {
            this.jCBservlet.setSelected(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jCBservlet) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.deployData.setMakeEntry(bl);
            this.enableInput(bl || Utilities.isJavaEE6(this.wizard));
        }
        this.fireChangeEvent();
    }

    private void enableInput(boolean bl) {
        this.jTFname.setEnabled(bl);
        this.jLinstruction.setEnabled(bl);
        this.jLclassname.setEnabled(bl);
        this.jLname.setEnabled(bl);
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setEnabled(bl);
            this.jLmapping.setEnabled(bl);
            this.paramPanel.setEnabled(bl);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setEnabled(bl);
        }
        if (bl) {
            this.jTFclassname.setDisabledTextColor(Color.black);
            this.jTFclassname.repaint();
            this.jTFname.setBackground(Color.white);
            if (this.fileType == FileType.SERVLET) {
                this.jTFmapping.setBackground(Color.white);
            }
        } else {
            this.jTFclassname.setDisabledTextColor(this.jTFname.getDisabledTextColor());
            this.jTFclassname.repaint();
            this.jTFname.setBackground(this.getBackground());
            if (this.fileType == FileType.SERVLET) {
                this.jTFmapping.setBackground(this.getBackground());
            }
        }
    }

    public HelpCtx getHelp() {
        return new HelpCtx(this.getClass().getName() + "." + this.evaluator.getFileType().toString());
    }
}

