/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ProfilerServer;

public class EventBufferManager
implements CommonConstants {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.server.EventBufferManager") != null;
    private File bufFile;
    private FileChannel bufFileChannel;
    private MappedByteBuffer mapByteBuf;
    private ProfilerServer profilerServer;
    private RandomAccessFile raFile;
    private String bufFileName;
    private boolean bufFileOk;
    private boolean remoteProfiling;

    public EventBufferManager(ProfilerServer profilerServer) {
        this.profilerServer = profilerServer;
        this.remoteProfiling = profilerServer.getProfilingSessionStatus().remoteProfiling;
    }

    public String getBufferFileName() {
        if (this.remoteProfiling) {
            return "";
        }
        return this.bufFileName;
    }

    public void eventBufferDumpHook(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (!this.remoteProfiling) {
            if (!this.bufFileOk) {
                return;
            }
            if (DEBUG) {
                System.err.println("EventBufferManager.DEBUG: Dumping to file: startPos:" + n + ", length:" + n3);
            }
            this.mapByteBuf.reset();
            this.mapByteBuf.put(byArray, n, n3);
            this.bufFileOk = this.profilerServer.sendEventBufferDumpedCommand(n3, null, -1);
        } else {
            if (DEBUG) {
                System.err.println("EventBufferManager.DEBUG: Dumping to compressed wire: startPos:" + n + ", length:" + n3);
            }
            this.profilerServer.sendEventBufferDumpedCommand(n3, byArray, n);
        }
    }

    public void freeBufferFile() {
        if (this.remoteProfiling) {
            return;
        }
        try {
            if (this.bufFileChannel != null) {
                this.mapByteBuf = null;
                this.bufFileChannel.close();
                this.raFile.close();
                System.gc();
                this.bufFileOk = false;
            }
        }
        catch (IOException iOException) {
            System.err.println("Profiler Agent Error: internal error when closing temporary memory-mapped communication file");
        }
    }

    public void openBufferFile(int n) throws IOException {
        if (this.remoteProfiling) {
            return;
        }
        if (this.bufFileOk) {
            return;
        }
        try {
            this.bufFile = File.createTempFile("jfluidbuf", null);
            this.bufFileName = this.bufFile.getCanonicalPath();
            if (Platform.isUnix()) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "666", this.bufFileName});
                }
                catch (Exception exception) {
                    System.err.println("*** JFluid Warning: Failed to set access permissions on temporary buffer file, you may not be able to attach as a different user: " + exception.getMessage());
                }
            }
            this.raFile = new RandomAccessFile(this.bufFile, "rw");
            this.bufFileChannel = this.raFile.getChannel();
            this.mapByteBuf = this.bufFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
            this.mapByteBuf.rewind();
            this.mapByteBuf.mark();
            this.bufFileOk = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Profiler Agent Error: FileNotFoundException in EventBufferManager.openBufferFile - should not happen!");
            return;
        }
        catch (IOException iOException) {
            System.err.println("Profiler Agent Error: Could not create temporary buffer file in the default temporary directory: " + iOException.getMessage() + ": " + System.getProperty("java.io.tmpdir"));
            throw new IOException("Could not create temporary buffer file in the default temporary directory: " + iOException.getMessage() + ": " + System.getProperty("java.io.tmpdir"));
        }
    }
}

