/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.WeakListeners;

public class RefCacheSupport {
    public static final long UNRESOLVED_EXPIRATION_DELAY = 5000L;
    private SchemaModel mSModel;
    private WeakHashMap<SchemaModelReference, Object> refModelCache = new WeakHashMap();
    private PropertyChangeListener mPropertySelfListener = null;
    private PropertyChangeListener mPropertyExtListener = null;

    public RefCacheSupport(SchemaModel schemaModel) {
        this.mSModel = schemaModel;
    }

    public int getCachedModelsSize() {
        return this.refModelCache.size();
    }

    public int checkKeys() {
        int n = 0;
        for (SchemaModelReference schemaModelReference : this.refModelCache.keySet()) {
            if (schemaModelReference.getModel() == this.mSModel) continue;
            ++n;
        }
        return n;
    }

    public SchemaModelImpl getCachedModel(SchemaModelReference schemaModelReference) {
        Object object = this.refModelCache.get(schemaModelReference);
        if (object != null && object instanceof SmAttachment) {
            return ((SmAttachment)SmAttachment.class.cast((Object)object)).mSchemaModel;
        }
        return null;
    }

    public boolean contains(SchemaModelImpl schemaModelImpl) {
        return this.refModelCache.containsValue(schemaModelImpl);
    }

    public SchemaModelImpl optimizedResolve(SchemaModelReference schemaModelReference) {
        try {
            Object object;
            Object object2 = this.refModelCache.get(schemaModelReference);
            if (object2 != null) {
                if (object2 instanceof SmAttachment) {
                    object = (SmAttachment)SmAttachment.class.cast(object2);
                    SchemaModelImpl schemaModelImpl = ((SmAttachment)object).mSchemaModel;
                    Model.State state = schemaModelImpl.getState();
                    if (state == Model.State.VALID) {
                        return schemaModelImpl;
                    }
                    this.excludeModel(schemaModelImpl);
                } else if (object2 instanceof UnresolvedSchemaRef && System.currentTimeMillis() < ((UnresolvedSchemaRef)UnresolvedSchemaRef.class.cast((Object)object2)).expiratoinTime) {
                    return null;
                }
            }
            if ((object = (SchemaModelImpl)schemaModelReference.resolveReferencedModel()) != null) {
                this.attach(schemaModelReference, (SchemaModelImpl)object);
            } else {
                this.refModelCache.put(schemaModelReference, new UnresolvedSchemaRef());
            }
            return object;
        }
        catch (CatalogModelException catalogModelException) {
            this.refModelCache.put(schemaModelReference, new UnresolvedSchemaRef());
            return null;
        }
    }

    public void discardCache() {
        for (Object object : this.refModelCache.values()) {
            if (!(object instanceof SmAttachment)) continue;
            SmAttachment smAttachment = (SmAttachment)SmAttachment.class.cast(object);
            smAttachment.mSchemaModel.removePropertyChangeListener(smAttachment.mPCL);
        }
        this.refModelCache.clear();
        this.mSModel.removePropertyChangeListener(this.mPropertySelfListener);
    }

    private void lazySelfListenerInit() {
        if (this.mPropertySelfListener == null) {
            this.mPropertySelfListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    Object object2;
                    Object object3;
                    String string = propertyChangeEvent.getPropertyName();
                    if ("schemaReferences".equals(string)) {
                        object3 = propertyChangeEvent.getNewValue();
                        object2 = propertyChangeEvent.getOldValue();
                        if (object3 == null && object2 != null && object2 instanceof SchemaModelReference) {
                            object = (SchemaModelReference)SchemaModelReference.class.cast(object2);
                            RefCacheSupport.this.excludeModelRef((SchemaModelReference)object);
                        }
                    }
                    if ("schemaLocation".equals(string) && (object3 = propertyChangeEvent.getSource()) != null && object3 instanceof SchemaModelReference) {
                        RefCacheSupport.this.excludeModelRef((SchemaModelReference)object3);
                    }
                    if ("namespace".equals(string) && (object3 = propertyChangeEvent.getSource()) != null && object3 instanceof Import) {
                        RefCacheSupport.this.excludeModelRef((Import)object3);
                    }
                    if ("state".equals(string)) {
                        object3 = propertyChangeEvent.getOldValue();
                        object2 = propertyChangeEvent.getNewValue();
                        object = propertyChangeEvent.getSource();
                        if (object2 != Model.State.VALID && object == RefCacheSupport.this.mSModel) {
                            RefCacheSupport.this.discardCache();
                        }
                        if (object3 != Model.State.VALID && object2 == Model.State.VALID && object == RefCacheSupport.this.mSModel) {
                            RefCacheSupport.this.discardCache();
                        }
                    }
                }
            };
            this.mSModel.addPropertyChangeListener(this.mPropertySelfListener);
        }
    }

    private synchronized void attach(SchemaModelReference schemaModelReference, SchemaModelImpl schemaModelImpl) {
        this.lazySelfListenerInit();
        if (this.mPropertyExtListener == null) {
            this.initExtListener();
        }
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.mPropertySelfListener, (Object)schemaModelImpl);
        schemaModelImpl.addPropertyChangeListener(propertyChangeListener);
        this.refModelCache.put(schemaModelReference, new SmAttachment(schemaModelImpl, propertyChangeListener));
    }

    private synchronized void excludeModel(SchemaModel schemaModel) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<SchemaModelReference, Object> entry : this.refModelCache.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof SmAttachment)) continue;
            SmAttachment smAttachment = (SmAttachment)SmAttachment.class.cast(object);
            if (!schemaModel.equals(smAttachment.mSchemaModel)) continue;
            arrayList.add(entry.getKey());
        }
        for (Map.Entry<SchemaModelReference, Object> entry : arrayList) {
            this.excludeModelRef((SchemaModelReference)((Object)entry));
        }
    }

    private synchronized void excludeModelRef(SchemaModelReference schemaModelReference) {
        Object object = this.refModelCache.remove(schemaModelReference);
        if (object != null && object instanceof SmAttachment) {
            SmAttachment smAttachment = (SmAttachment)SmAttachment.class.cast(object);
            smAttachment.mSchemaModel.removePropertyChangeListener(smAttachment.mPCL);
        }
    }

    private void initExtListener() {
        this.mPropertyExtListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                Object object2;
                String string = propertyChangeEvent.getPropertyName();
                if ("state".equals(string)) {
                    object2 = propertyChangeEvent.getOldValue();
                    object = propertyChangeEvent.getNewValue();
                    Object object3 = propertyChangeEvent.getSource();
                    if (object != Model.State.VALID && object3 instanceof SchemaModel) {
                        RefCacheSupport.this.excludeModel((SchemaModel)SchemaModel.class.cast(object3));
                    }
                    if (object2 != Model.State.VALID && object == Model.State.VALID && object3 == RefCacheSupport.this.mSModel) {
                        RefCacheSupport.this.excludeModel((SchemaModel)SchemaModel.class.cast(object3));
                    }
                }
                if ("targetNamespace".equals(string) && (object2 = propertyChangeEvent.getSource()) instanceof Schema) {
                    object = (Schema)Schema.class.cast(object2);
                    RefCacheSupport.this.excludeModel(object.getModel());
                }
            }
        };
    }

    private static class UnresolvedSchemaRef {
        public long expiratoinTime = System.currentTimeMillis() + 5000L;
    }

    private static class SmAttachment {
        public SchemaModelImpl mSchemaModel;
        public PropertyChangeListener mPCL;

        public SmAttachment(SchemaModelImpl schemaModelImpl, PropertyChangeListener propertyChangeListener) {
            assert (schemaModelImpl != null && propertyChangeListener != null);
            this.mSchemaModel = schemaModelImpl;
            this.mPCL = propertyChangeListener;
        }
    }
}

