/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MemoryMeasurementFailedException;

public class MemoryMeasurement {
    public static final String IDE_PID_SYSTEM_PROPERTY = "netbeans.pid";
    private static final long UNKNOWN_VALUE = -1L;
    private static final String SOLARIS = "solaris";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "win32";
    private static final String UNKNOWN = "unknown";
    private static final String[][] SUPPORTED_PLATFORMS = new String[][]{{"SunOS", "solaris"}, {"Linux", "linux"}, {"Windows NT", "win32"}, {"Windows 2000", "win32"}, {"Windows XP", "win32"}};
    private static boolean libraryLoaded = false;

    private MemoryMeasurement() {
    }

    public static long getIdeMemoryFootPrint() throws MemoryMeasurementFailedException {
        String string = System.getProperty(IDE_PID_SYSTEM_PROPERTY);
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                return MemoryMeasurement.getProcessMemoryFootPrint(l);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MemoryMeasurementFailedException("Cannot get IDE PID - obtained value: " + string);
    }

    public static long getProcessMemoryFootPrint(long l) throws MemoryMeasurementFailedException {
        String string = MemoryMeasurement.getPlatform();
        if (string.equals(SOLARIS) | string.equals(LINUX)) {
            return MemoryMeasurement.getProcessMemoryFootPrintOnUnix(l);
        }
        if (string.equals(WINDOWS)) {
            return MemoryMeasurement.getProcessMemoryFootPrintOnWindows(l);
        }
        throw new MemoryMeasurementFailedException("Cannot measure memory on unsupported platform " + string);
    }

    private static String getPlatform() throws MemoryMeasurementFailedException {
        String string = System.getProperty("os.name");
        for (int i = 0; i < SUPPORTED_PLATFORMS.length; ++i) {
            if (!SUPPORTED_PLATFORMS[i][0].equalsIgnoreCase(string)) continue;
            return SUPPORTED_PLATFORMS[i][1];
        }
        throw new MemoryMeasurementFailedException("MemoryMeasurement does not support this operating system: " + string);
    }

    private static long getProcessMemoryFootPrintOnUnix(long l) throws MemoryMeasurementFailedException {
        try {
            File file = new File(Manager.getNbJUnitHome(), "memory-measurement.unix.sh");
            if (!file.exists()) {
                throw new MemoryMeasurementFailedException("Cannot locate script '" + file.getName() + "', please make sure it is available in nbjunit.home");
            }
            String string = "/bin/sh " + file.getAbsolutePath() + " " + l;
            Process process = Runtime.getRuntime().exec(string);
            long l2 = MemoryMeasurement.getOutputValue(process);
            process.waitFor();
            if (l2 == -1L) {
                throw new MemoryMeasurementFailedException("Memory measurement call failed " + l2);
            }
            return l2;
        }
        catch (IOException iOException) {
            throw new MemoryMeasurementFailedException("MemoryMeasurement failed, reason:" + iOException.getMessage(), iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new MemoryMeasurementFailedException("MemoryMeasurement failed, reason:" + interruptedException.getMessage(), interruptedException);
        }
    }

    private static long getProcessMemoryFootPrintOnWindows(long l) throws MemoryMeasurementFailedException {
        MemoryMeasurement.loadMemoryMeasurementLibrary();
        long l2 = MemoryMeasurement.getProcessMemoryFootPrintNative(l);
        if (l2 == -1L) {
            throw new MemoryMeasurementFailedException("Memory measurement call to native library failed - could not measure memory of process with pid " + l + ".");
        }
        return l2;
    }

    private static native long getProcessMemoryFootPrintNative(long var0);

    private static long getOutputValue(Process process) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            try {
                long l = Long.parseLong(string);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Received String is not a number: " + string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private static void loadMemoryMeasurementLibrary() throws MemoryMeasurementFailedException {
        if (!libraryLoaded) {
            try {
                File file = new File(Manager.getNbJUnitHome(), "lib.memory-measurement.win32.dll");
                System.load(file.getAbsolutePath());
                libraryLoaded = true;
            }
            catch (IOException iOException) {
                throw new MemoryMeasurementFailedException("Cannot load native memory measurement library lib.memory-measurement.win32.dll, reason: " + iOException.getMessage(), iOException);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new MemoryMeasurementFailedException("Cannot load native memory measurement library lib.memory-measurement.win32.dll, reason: " + unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            }
        }
    }
}

