/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MasterPanel
implements WizardDescriptor.Panel {
    private boolean valid;
    private EventListenerList listenerList;
    private boolean inNewProject;
    private WizardDescriptor wizardDesc;
    private String lastMsg;
    private boolean lastMsgInfoIconEnabled;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availablePane;
    private JComboBox connectionCombo;
    private JLabel connectionLabel;
    private JButton downButton;
    private JLabel includeLabel;
    private JList includeList;
    private JScrollPane includePane;
    private JPanel masterPanel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JComboBox tableCombo;
    private JLabel tableLabel;
    private JButton upButton;

    public MasterPanel(boolean bl) {
        this.inNewProject = bl;
    }

    private void initGUI() {
        this.initComponents();
        this.initLists();
        DatabaseExplorerUIs.connect((JComboBox)this.connectionCombo, (ConnectionManager)ConnectionManager.getDefault());
    }

    private void initLists() {
        this.availableList.setModel(new DefaultListModel());
        this.includeList.setModel(new DefaultListModel());
        ListDataListener listDataListener = new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                Object object = listDataEvent.getSource();
                if (object == MasterPanel.this.availableList.getModel()) {
                    MasterPanel.this.addAllButton.setEnabled(MasterPanel.this.availableList.getModel().getSize() != 0);
                } else if (object == MasterPanel.this.includeList.getModel()) {
                    boolean bl = MasterPanel.this.includeList.getModel().getSize() == 0;
                    MasterPanel.this.removeAllButton.setEnabled(!bl);
                    MasterPanel.this.setValid(!bl);
                }
            }
        };
        this.availableList.getModel().addListDataListener(listDataListener);
        this.includeList.getModel().addListDataListener(listDataListener);
    }

    private void initComponents() {
        this.masterPanel = new JPanel();
        this.connectionCombo = new JComboBox();
        this.connectionLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableCombo = new JComboBox();
        this.availableLabel = new JLabel();
        this.availablePane = new JScrollPane();
        this.availableList = new JList();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.includePane = new JScrollPane();
        this.includeList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.includeLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.masterPanel.setName(NbBundle.getMessage(MasterPanel.class, (String)"TITLE_MasterPanel"));
        this.connectionCombo.addActionListener(formListener);
        this.connectionLabel.setLabelFor(this.connectionCombo);
        Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseConnection"));
        this.tableLabel.setLabelFor(this.tableCombo);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseTable"));
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(J2EEUtils.DBColumnInfo.getRenderer());
        this.tableCombo.addActionListener(formListener);
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_AvailableColumns"));
        this.availableList.addListSelectionListener(formListener);
        this.availablePane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_AvailableColumns_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAdd"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(formListener);
        this.includeList.addListSelectionListener(formListener);
        this.includePane.setViewportView(this.includeList);
        this.includeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_ColumnsToInclude_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterUp"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(formListener);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterDown"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(formListener);
        this.includeLabel.setLabelFor(this.includeList);
        Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_ColumnsToInclude"));
        GroupLayout groupLayout = new GroupLayout((Container)this.masterPanel);
        this.masterPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.connectionLabel).add((Component)this.tableLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tableCombo, 0, 290, Short.MAX_VALUE).add((Component)this.connectionCombo, 0, 290, Short.MAX_VALUE))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.availablePane, -1, 152, Short.MAX_VALUE).add((Component)this.availableLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.addButton, -1, -1, Short.MAX_VALUE).add((Component)this.addAllButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeAllButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includePane, -1, 150, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.upButton, -1, -1, Short.MAX_VALUE).add((Component)this.downButton, -1, -1, Short.MAX_VALUE))).add((Component)this.includeLabel)))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addAllButton, this.addButton, this.downButton, this.removeAllButton, this.removeButton, this.upButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionLabel).add((Component)this.connectionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tableLabel).add((Component)this.tableCombo, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.availableLabel).add((Component)this.includeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.availablePane, 0, 152, Short.MAX_VALUE).add((Component)this.includePane, 0, 152, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 15, Short.MAX_VALUE).add((Component)this.addButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addAllButton).add((Component)this.upButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.removeButton).add((Component)this.downButton)).addPreferredGap(0).add((Component)this.removeAllButton).addPreferredGap(0, 15, Short.MAX_VALUE))).addContainerGap()));
        this.connectionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseConnection_ACSD"));
        this.tableCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseTable_ACSD"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAddAll_ACSD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAdd_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemove_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterUp_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterDown_ACSD"));
        this.masterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"TITLE_MasterPanel"));
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        int n = this.includeList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n + 1, e);
        this.includeList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        int n = this.includeList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n - 1, e);
        this.includeList.setSelectedIndex(n - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        MasterPanel.moveListItems(this.includeList, this.availableList, false);
        this.showMsg("MSG_AtLeastOneColumnIncluded");
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        MasterPanel.moveListItems(this.includeList, this.availableList, true);
        if (this.includeList.getModel().getSize() == 0) {
            this.showMsg("MSG_AtLeastOneColumnIncluded");
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        MasterPanel.moveListItems(this.availableList, this.includeList, true);
        this.hideMsg();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        MasterPanel.moveListItems(this.availableList, this.includeList, false);
        this.hideMsg();
    }

    private void includeListValueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.includeList.getSelectedIndices();
        boolean bl = nArray.length == 1;
        this.upButton.setEnabled(bl && nArray[0] != 0);
        this.downButton.setEnabled(bl && nArray[0] != this.includeList.getModel().getSize() - 1);
        boolean bl2 = nArray.length > 0;
        this.removeButton.setEnabled(bl2);
        if (bl2) {
            this.availableList.clearSelection();
        }
    }

    private void availableListValueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.availableList.getSelectedIndex() != -1;
        this.addButton.setEnabled(bl);
        if (bl) {
            this.includeList.clearSelection();
        }
    }

    private void tableComboActionPerformed(ActionEvent actionEvent) {
        Connection connection;
        J2EEUtils.DBColumnInfo dBColumnInfo = this.getTable();
        DatabaseConnection databaseConnection = this.getConnection();
        Connection connection2 = connection = databaseConnection == null || dBColumnInfo == null || !dBColumnInfo.isValid() ? null : databaseConnection.getJDBCConnection();
        if (dBColumnInfo != null) {
            if (!dBColumnInfo.isValid()) {
                this.showMsg("MSG_MasterInvalidTableSelected");
            } else {
                this.hideMsg();
            }
        }
        try {
            DefaultListModel defaultListModel = (DefaultListModel)this.availableList.getModel();
            defaultListModel.clear();
            defaultListModel = (DefaultListModel)this.includeList.getModel();
            defaultListModel.clear();
            if (connection != null) {
                ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), databaseConnection.getSchema(), dBColumnInfo.getName(), "%");
                while (resultSet.next()) {
                    String string = resultSet.getString("COLUMN_NAME");
                    defaultListModel.addElement(string);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
    }

    private void connectionComboActionPerformed(ActionEvent actionEvent) {
        DatabaseConnection databaseConnection = this.getConnection();
        if (databaseConnection != null) {
            this.hideMsg();
            Connection connection = J2EEUtils.establishConnection(databaseConnection);
            if (connection == null) {
                return;
            }
            this.fillTableCombo(databaseConnection);
        } else {
            this.fillTableCombo(null);
        }
    }

    private DatabaseConnection getConnection() {
        Object object = this.connectionCombo.getSelectedItem();
        return object instanceof DatabaseConnection ? (DatabaseConnection)object : null;
    }

    private J2EEUtils.DBColumnInfo getTable() {
        return (J2EEUtils.DBColumnInfo)this.tableCombo.getSelectedItem();
    }

    private List getSelectedColumns() {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        return Arrays.asList(defaultListModel.toArray());
    }

    private void fillTableCombo(DatabaseConnection databaseConnection) {
        DefaultComboBoxModel<J2EEUtils.DBColumnInfo> defaultComboBoxModel = new DefaultComboBoxModel<J2EEUtils.DBColumnInfo>();
        int n = 0;
        if (databaseConnection != null) {
            for (J2EEUtils.DBColumnInfo dBColumnInfo : J2EEUtils.tableNamesForConnection(databaseConnection)) {
                if (!dBColumnInfo.isValid()) {
                    ++n;
                }
                defaultComboBoxModel.addElement(dBColumnInfo);
            }
        }
        this.tableCombo.setModel(defaultComboBoxModel);
        this.tableCombo.setEnabled(this.tableCombo.getModel().getSize() != 0);
        this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
        if (databaseConnection != null) {
            if (defaultComboBoxModel.getSize() == 0) {
                this.showMsg("MSG_MasterDBWithoutTables");
            } else if (n == defaultComboBoxModel.getSize()) {
                this.showMsg("MSG_MasterDBWithoutTablesWithPrimaryKeys");
            } else {
                this.hideMsg();
            }
        }
    }

    private static void moveListItems(JList jList, JList jList2, boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)jList2.getModel();
        if (bl) {
            int n;
            int[] nArray = jList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                Object e = defaultListModel.getElementAt(nArray[n]);
                defaultListModel2.addElement(e);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                defaultListModel.removeElementAt(nArray[n]);
            }
        } else {
            Enumeration enumeration = defaultListModel.elements();
            while (enumeration.hasMoreElements()) {
                defaultListModel2.addElement(enumeration.nextElement());
            }
            defaultListModel.clear();
        }
    }

    public Component getComponent() {
        if (this.masterPanel == null) {
            this.initGUI();
        }
        return this.masterPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.form.j2ee.wizard.MasterPanel");
    }

    public void readSettings(Object object) {
        this.wizardDesc = (WizardDescriptor)object;
        boolean bl = true;
        if (!this.inNewProject && object instanceof TemplateWizard) {
            try {
                FileObject fileObject;
                TemplateWizard templateWizard = (TemplateWizard)object;
                DataFolder dataFolder = templateWizard.getTargetFolder();
                FileObject fileObject2 = dataFolder.getPrimaryFile();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
                String string = classPath.getResourceName(fileObject2).trim();
                boolean bl2 = bl = string.length() != 0;
                if (!bl) {
                    this.showMsg("MSG_MasterDefaultPackage");
                } else {
                    fileObject = classPath.findOwnerRoot(fileObject2);
                    URL[] uRLArray = UnitTestForSourceQuery.findSources((FileObject)fileObject);
                    if (uRLArray.length != 0) {
                        this.showMsg("MSG_MasterTestPackage");
                        bl = false;
                    }
                }
                fileObject = FileOwnerQuery.getOwner((FileObject)fileObject2);
                if (fileObject.getLookup().lookup(PersistenceLocationProvider.class) == null) {
                    this.showMsg("MSG_MasterNoProvider");
                    bl = false;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        this.connectionCombo.setEnabled(bl);
        if (!bl) {
            this.setValid(false);
        } else if (this.connectionCombo.getSelectedItem() == null) {
            this.showMsg("MSG_MasterDefaultConnection", true);
        }
        if (this.lastMsg != null) {
            this.showMsg(this.lastMsg, this.lastMsgInfoIconEnabled);
        }
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        wizardDescriptor.putProperty("connection", (Object)this.getConnection());
        J2EEUtils.DBColumnInfo dBColumnInfo = this.getTable();
        if (dBColumnInfo != null) {
            wizardDescriptor.putProperty("master", (Object)dBColumnInfo.getName());
        }
        wizardDescriptor.putProperty("masterColumns", (Object)this.getSelectedColumns());
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean bl) {
        if (bl == this.valid) {
            return;
        }
        this.valid = bl;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = changeListenerArray.length - 1; i >= 0; --i) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    private void showMsg(String string) {
        this.showMsg(string, false);
    }

    private void showMsg(String string, boolean bl) {
        this.lastMsg = string;
        this.lastMsgInfoIconEnabled = bl;
        if (this.wizardDesc != null) {
            if (string != null) {
                string = NbBundle.getMessage(this.getClass(), (String)string);
            }
            if (bl) {
                this.wizardDesc.putProperty("WizardPanel_infoMessage", (Object)string);
            } else {
                this.wizardDesc.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }
    }

    private void hideMsg() {
        this.showMsg(null, true);
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MasterPanel.this.connectionCombo) {
                MasterPanel.this.connectionComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.tableCombo) {
                MasterPanel.this.tableComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.addAllButton) {
                MasterPanel.this.addAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.addButton) {
                MasterPanel.this.addButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.removeButton) {
                MasterPanel.this.removeButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.removeAllButton) {
                MasterPanel.this.removeAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.upButton) {
                MasterPanel.this.upButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MasterPanel.this.downButton) {
                MasterPanel.this.downButtonActionPerformed(actionEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == MasterPanel.this.availableList) {
                MasterPanel.this.availableListValueChanged(listSelectionEvent);
            } else if (listSelectionEvent.getSource() == MasterPanel.this.includeList) {
                MasterPanel.this.includeListValueChanged(listSelectionEvent);
            }
        }
    }
}

