/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.reflect.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldUtils {
    private FieldUtils() {
    }

    public static Collection<Field> getDeclared(Class clazz, Filter<Field> filter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter must not be null!");
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>(fieldArray.length);
        for (Field field : fieldArray) {
            if (filter != null && !filter.accept(field)) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    public static Map<String, Field> getAll(Class clazz, Class clazz2, Filter<Field> filter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter must not be null!");
        }
        if (clazz2 == null) {
            clazz2 = Object.class;
        }
        if (clazz2.isInterface()) {
            throw new IllegalArgumentException("Stop at class " + clazz2.getName() + " must not be an interface");
        }
        if (!ClassUtils.isSuperclass(clazz, clazz2) && !clazz.equals(clazz2)) {
            throw new IllegalArgumentException("Stop At class class " + clazz2.getName() + " is not superclass of " + clazz.getName());
        }
        LinkedHashMap<String, Field> linkedHashMap = new LinkedHashMap<String, Field>();
        boolean bl = false;
        while (!bl) {
            for (Field field : clazz.getDeclaredFields()) {
                if (((HashMap)linkedHashMap).get(field.getName()) != null || filter != null && !filter.accept(field)) continue;
                linkedHashMap.put(field.getName(), field);
            }
            if (clazz.equals(clazz2)) {
                bl = true;
            }
            clazz = clazz.getSuperclass();
        }
        return linkedHashMap;
    }

    public static Filter<Field> modifierFilterPositive(int ... nArray) {
        return new FieldModifierFilter(true, nArray);
    }

    public static Filter<Field> modifierFilterNegative(int ... nArray) {
        return new FieldModifierFilter(false, nArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldModifierFilter
    implements Filter<Field> {
        private boolean isPositive;
        private int modifs;

        public FieldModifierFilter(boolean bl, int ... nArray) {
            this.isPositive = bl;
            for (int n : nArray) {
                this.modifs |= n;
            }
        }

        @Override
        public boolean accept(Field field) {
            return this.isPositive ? (field.getModifiers() & this.modifs) == this.modifs : (field.getModifiers() & this.modifs) == 0;
        }
    }
}

