/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.lang.reflect.Array;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] copy(T[] TArray) {
        T[] TArray2 = ArrayUtil.newArray(TArray, TArray.length);
        System.arraycopy(TArray, 0, TArray2, 0, TArray.length);
        return TArray2;
    }

    public static <T> T[] union(T[] TArray, T ... TArray2) {
        T[] TArray3 = ArrayUtil.newArray(TArray, TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, TArray3, 0, TArray.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    public static <T> boolean contains(T[] TArray, T ... TArray2) {
        for (T t : TArray2) {
            boolean bl = false;
            for (T t2 : TArray) {
                if (!t2.equals(t)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterator<T> iterator(T[] TArray) {
        return new ArrayIterator<T>(TArray);
    }

    private static <T> T[] newArray(T[] TArray, int n) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIterator<T>
    implements Iterator<T> {
        private T[] array;
        private int i = 0;

        public ArrayIterator(T[] TArray) {
            this.array = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.i;
        }

        @Override
        public T next() {
            return this.array[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

