/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(Ruby ruby) {
        RubyClassPathVariable rubyClassPathVariable = new RubyClassPathVariable(ruby);
        ruby.getEnumerable().extend_object(rubyClassPathVariable);
        ruby.defineReadonlyVariable("$CLASSPATH", rubyClassPathVariable);
        rubyClassPathVariable.getMetaClass().defineAnnotatedMethods(RubyClassPathVariable.class);
    }

    private RubyClassPathVariable(Ruby ruby) {
        super(ruby, ruby.getObject());
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(IRubyObject iRubyObject) throws Exception {
        String string = iRubyObject.convertToString().toString();
        URL uRL = this.getURL(string);
        this.getRuntime().getJRubyClassLoader().addURL(uRL);
        return this;
    }

    private URL getURL(String string) throws MalformedURLException {
        if (string.indexOf("://") == -1) {
            return new File(string).toURI().toURL();
        }
        return new URL(string);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getRuntime().getJRubyClassLoader().getURLs().length);
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(Block block) {
        URL[] uRLArray = this.getRuntime().getJRubyClassLoader().getURLs();
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        int n = uRLArray.length;
        for (int i = 0; i < n; ++i) {
            block.yield(threadContext, this.getRuntime().newString(uRLArray[i].toString()));
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "inspect");
    }
}

