/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.javasupport.JavaEmbedUtils;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.IOInputStream;
import org.jruby.nb.util.IOOutputStream;
import org.jruby.nb.yaml.JRubyConstructor;
import org.jruby.nb.yaml.JRubyRepresenter;
import org.jruby.nb.yaml.JRubySerializer;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Emitter;
import org.jvyamlb.EmitterImpl;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Position;
import org.jvyamlb.Positionable;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParser;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.Scanner;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.exceptions.YAMLException;

@JRubyModule(name={"YAML"})
public class RubyYAML {
    private static final Pattern AFTER_NEWLINE = Pattern.compile("\n.+", 32);

    public static RubyModule createYAMLModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("YAML");
        ruby.getKernel().callMethod(ruby.getCurrentContext(), "require", ruby.newString("stringio"));
        rubyModule.defineAnnotatedMethods(RubyYAML.class);
        RubyClass rubyClass = ruby.getObject();
        RubyClass rubyClass2 = ruby.getClassClass();
        RubyClass rubyClass3 = ruby.getHash();
        RubyClass rubyClass4 = ruby.getArray();
        RubyClass rubyClass5 = ruby.getStructClass();
        RubyClass rubyClass6 = ruby.getException();
        RubyClass rubyClass7 = ruby.getString();
        RubyClass rubyClass8 = ruby.getSymbol();
        RubyClass rubyClass9 = ruby.getRange();
        RubyClass rubyClass10 = ruby.getRegexp();
        RubyClass rubyClass11 = ruby.getTime();
        RubyClass rubyClass12 = ruby.fastGetClass("Date");
        RubyClass rubyClass13 = ruby.getFixnum();
        RubyClass rubyClass14 = ruby.getBignum();
        RubyClass rubyClass15 = ruby.getFloat();
        RubyClass rubyClass16 = ruby.getTrueClass();
        RubyClass rubyClass17 = ruby.getFalseClass();
        RubyClass rubyClass18 = ruby.getNilClass();
        rubyClass2.defineAnnotatedMethods(YAMLClassMethods.class);
        rubyClass.defineAnnotatedMethods(YAMLObjectMethods.class);
        rubyClass3.defineAnnotatedMethods(YAMLHashMethods.class);
        rubyClass4.defineAnnotatedMethods(YAMLArrayMethods.class);
        rubyClass5.defineAnnotatedMethods(YAMLStructMethods.class);
        rubyClass6.defineAnnotatedMethods(YAMLExceptionMethods.class);
        rubyClass7.defineAnnotatedMethods(YAMLStringMethods.class);
        rubyClass8.defineAnnotatedMethods(YAMLSymbolMethods.class);
        rubyClass9.defineAnnotatedMethods(YAMLRangeMethods.class);
        rubyClass10.defineAnnotatedMethods(YAMLRegexpMethods.class);
        rubyClass11.defineAnnotatedMethods(YAMLTimeMethods.class);
        rubyClass12.defineAnnotatedMethods(YAMLDateMethods.class);
        rubyClass14.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass13.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass15.defineAnnotatedMethods(YAMLNumericMethods.class);
        rubyClass16.defineAnnotatedMethods(YAMLTrueMethods.class);
        rubyClass17.defineAnnotatedMethods(YAMLFalseMethods.class);
        rubyClass18.defineAnnotatedMethods(YAMLNilMethods.class);
        ruby.setObjectToYamlMethod(ruby.getObject().searchMethod("to_yaml"));
        return rubyModule;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray(iRubyObject2);
        if (iRubyObjectArray.length > 1) {
            return RuntimeHelpers.invoke(ruby.getCurrentContext(), iRubyObject, "dump_all", (IRubyObject)rubyArray, iRubyObjectArray[1]);
        }
        return iRubyObject.callMethod(ruby.getCurrentContext(), "dump_all", rubyArray);
    }

    @JRubyMethod(name={"dump_all"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_all(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        RubyArray rubyArray = (RubyArray)iRubyObjectArray[0];
        IRubyObject iRubyObject2 = null;
        IRubyObject iRubyObject3 = null;
        if (iRubyObjectArray.length == 2 && iRubyObjectArray[1] != null && !iRubyObjectArray[1].isNil()) {
            iRubyObject2 = iRubyObjectArray[1];
        }
        YAMLConfig yAMLConfig = YAML.config().version("1.0");
        IOOutputStream iOOutputStream = null;
        if (null == iRubyObject2) {
            iRubyObject3 = iRubyObject.getRuntime().fastGetClass("StringIO").callMethod(threadContext, "new");
            iOOutputStream = new IOOutputStream(iRubyObject3);
        } else {
            iOOutputStream = new IOOutputStream(iRubyObject2);
        }
        JRubySerializer jRubySerializer = new JRubySerializer((Emitter)new EmitterImpl((OutputStream)iOOutputStream, yAMLConfig), (Resolver)new ResolverImpl(), yAMLConfig);
        try {
            jRubySerializer.open();
            JRubyRepresenter jRubyRepresenter = new JRubyRepresenter((Serializer)jRubySerializer, yAMLConfig);
            Iterator iterator = rubyArray.getList().iterator();
            while (iterator.hasNext()) {
                jRubyRepresenter.represent(iterator.next());
            }
            jRubySerializer.close();
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
        if (null == iRubyObject2) {
            iRubyObject3.callMethod(threadContext, "rewind");
            return iRubyObject3.callMethod(threadContext, "read");
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"_parse_internal"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject parse_internal(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        boolean bl = iRubyObject.getRuntime().getDebug().isTrue();
        IRubyObject iRubyObject3 = RubyYAML.check_yaml_port(iRubyObject2);
        Object object = null;
        try {
            PositioningComposerImpl positioningComposerImpl;
            object = iRubyObject3 instanceof RubyString ? (bl ? new PositioningScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(((RubyString)iRubyObject3).getByteList())) : (bl ? new PositioningScannerImpl((InputStream)new IOInputStream(iRubyObject3)) : new ScannerImpl((InputStream)new IOInputStream(iRubyObject3)));
            Object object2 = positioningComposerImpl = bl ? new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl()) : new ComposerImpl((Parser)new ParserImpl((Scanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl());
            if (positioningComposerImpl.checkNode()) {
                return JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), positioningComposerImpl.getNode());
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)yAMLException).getRange();
                throw iRubyObject.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + yAMLException.getMessage());
            }
            throw iRubyObject.getRuntime().newArgumentError("syntax error:" + yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        boolean bl = iRubyObject.getRuntime().getDebug().isTrue();
        IRubyObject iRubyObject3 = RubyYAML.check_yaml_port(iRubyObject2);
        Object object = null;
        try {
            JRubyConstructor jRubyConstructor;
            object = iRubyObject3 instanceof RubyString ? (bl ? new PositioningScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(((RubyString)iRubyObject3).getByteList())) : (bl ? new PositioningScannerImpl((InputStream)new IOInputStream(iRubyObject3)) : new ScannerImpl((InputStream)new IOInputStream(iRubyObject3)));
            JRubyConstructor jRubyConstructor2 = jRubyConstructor = bl ? new JRubyConstructor(iRubyObject, (Composer)new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(iRubyObject, (Composer)new ComposerImpl((Parser)new ParserImpl((Scanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl()));
            if (jRubyConstructor.checkData()) {
                return JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData());
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)yAMLException).getRange();
                throw iRubyObject.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + yAMLException.getMessage());
            }
            throw iRubyObject.getRuntime().newArgumentError("syntax error:" + yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_file"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_file(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        IRubyObject iRubyObject3 = RuntimeHelpers.invoke(threadContext, (IRubyObject)ruby.getFile(), "open", iRubyObject2, ruby.newString("r"));
        IRubyObject iRubyObject4 = iRubyObject.callMethod(threadContext, "load", iRubyObject3);
        iRubyObject3.callMethod(threadContext, "close");
        return iRubyObject4;
    }

    @JRubyMethod(name={"each_document"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_document(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        boolean bl = iRubyObject.getRuntime().getDebug().isTrue();
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject2;
        Object object = null;
        try {
            JRubyConstructor jRubyConstructor;
            object = iRubyObject3 instanceof RubyString ? (bl ? new PositioningScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(((RubyString)iRubyObject3).getByteList())) : (bl ? new PositioningScannerImpl((InputStream)new IOInputStream(iRubyObject3)) : new ScannerImpl((InputStream)new IOInputStream(iRubyObject3)));
            JRubyConstructor jRubyConstructor2 = jRubyConstructor = bl ? new JRubyConstructor(iRubyObject, (Composer)new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(iRubyObject, (Composer)new ComposerImpl((Parser)new ParserImpl((Scanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                block.yield(threadContext, JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)yAMLException).getRange();
                throw iRubyObject.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + yAMLException.getMessage());
            }
            throw iRubyObject.getRuntime().newArgumentError("syntax error:" + yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_documents"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_documents(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        boolean bl = iRubyObject.getRuntime().getDebug().isTrue();
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = RubyYAML.check_yaml_port(iRubyObject2);
        Object object = null;
        try {
            JRubyConstructor jRubyConstructor;
            object = iRubyObject3 instanceof RubyString ? (bl ? new PositioningScannerImpl(((RubyString)iRubyObject3).getByteList()) : new ScannerImpl(((RubyString)iRubyObject3).getByteList())) : (bl ? new PositioningScannerImpl((InputStream)new IOInputStream(iRubyObject3)) : new ScannerImpl((InputStream)new IOInputStream(iRubyObject3)));
            JRubyConstructor jRubyConstructor2 = jRubyConstructor = bl ? new JRubyConstructor(iRubyObject, (Composer)new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(iRubyObject, (Composer)new ComposerImpl((Parser)new ParserImpl((Scanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                block.yield(threadContext, JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject.getRuntime().getNil();
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)yAMLException).getRange();
                throw iRubyObject.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + yAMLException.getMessage());
            }
            throw iRubyObject.getRuntime().newArgumentError("syntax error:" + yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"load_stream"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load_stream(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        boolean bl = iRubyObject.getRuntime().getDebug().isTrue();
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject.getRuntime().getNil();
        IRubyObject iRubyObject4 = iRubyObject2;
        Object object = null;
        try {
            JRubyConstructor jRubyConstructor;
            object = iRubyObject4 instanceof RubyString ? (bl ? new PositioningScannerImpl(((RubyString)iRubyObject4).getByteList()) : new ScannerImpl(((RubyString)iRubyObject4).getByteList())) : (bl ? new PositioningScannerImpl((InputStream)new IOInputStream(iRubyObject4)) : new ScannerImpl((InputStream)new IOInputStream(iRubyObject4)));
            JRubyConstructor jRubyConstructor2 = jRubyConstructor = bl ? new JRubyConstructor(iRubyObject, (Composer)new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl())) : new JRubyConstructor(iRubyObject, (Composer)new ComposerImpl((Parser)new ParserImpl((Scanner)object, YAML.config().version("1.0")), (Resolver)new ResolverImpl()));
            while (jRubyConstructor.checkData()) {
                if (iRubyObject3.isNil()) {
                    iRubyObject3 = iRubyObject.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(threadContext, "new", iRubyObject3);
                }
                iRubyObject3.callMethod(threadContext, "add", JavaEmbedUtils.javaToRuby(iRubyObject.getRuntime(), jRubyConstructor.getData()));
            }
            return iRubyObject3;
        }
        catch (YAMLException yAMLException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                Position.Range range = ((Positionable)yAMLException).getRange();
                throw iRubyObject.getRuntime().newArgumentError("syntax error on " + range.start + ":" + range.end + ": " + yAMLException.getMessage());
            }
            throw iRubyObject.getRuntime().newArgumentError("syntax error:" + yAMLException.getMessage());
        }
    }

    @JRubyMethod(name={"dump_stream"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump_stream(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().fastGetModule("YAML").fastGetClass("Stream").callMethod(threadContext, "new");
        int n = iRubyObjectArray.length;
        for (int i = 0; i < n; ++i) {
            iRubyObject2.callMethod(threadContext, "add", iRubyObjectArray[i]);
        }
        return iRubyObject2.callMethod(threadContext, "emit");
    }

    @JRubyMethod(name={"quick_emit_node"}, required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject quick_emit_node(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return block.yield(iRubyObject.getRuntime().getCurrentContext(), iRubyObjectArray[0]);
    }

    public static IRubyObject quick_emit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return iRubyObject.getRuntime().getNil();
    }

    private static IRubyObject check_yaml_port(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyString)) {
            if (iRubyObject.respondsTo("read")) {
                if (iRubyObject.respondsTo("binmode")) {
                    ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
                    iRubyObject.callMethod(threadContext, "binmode");
                }
            } else {
                throw iRubyObject.getRuntime().newTypeError("instance of IO needed");
            }
        }
        return iRubyObject;
    }

    @JRubyClass(name={"NilClass"})
    public static class YAMLNilMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject nil_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)iRubyObject.getRuntime().newString(""), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"FalseClass"})
    public static class YAMLFalseMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject false_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject false_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    @JRubyClass(name={"TrueClass"})
    public static class YAMLTrueMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject true_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject true_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:bool");
        }
    }

    @JRubyClass(name={"Date"})
    public static class YAMLDateMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject date_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s"), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Time"})
    public static class YAMLTimeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject time_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3;
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            IRubyObject iRubyObject4 = iRubyObject.getRuntime().newString("Z");
            RubyString rubyString = iRubyObject.getRuntime().newString("-");
            if (!(iRubyObject = iRubyObject.dup()).callMethod(threadContext, "utc?").isTrue()) {
                IRubyObject iRubyObject5;
                iRubyObject3 = iRubyObject.callMethod(threadContext, "utc");
                IRubyObject iRubyObject6 = RuntimeHelpers.invoke(threadContext, (IRubyObject)iRubyObject.getRuntime().getTime(), "utc", new IRubyObject[]{iRubyObject.callMethod(threadContext, "year"), iRubyObject.callMethod(threadContext, "month"), iRubyObject.callMethod(threadContext, "day"), iRubyObject.callMethod(threadContext, "hour"), iRubyObject.callMethod(threadContext, "min"), iRubyObject.callMethod(threadContext, "sec"), iRubyObject.callMethod(threadContext, "usec")});
                IRubyObject iRubyObject7 = iRubyObject6.callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject3);
                if (iRubyObject7.callMethod(threadContext, MethodIndex.OP_LT, "<", RubyFixnum.zero(iRubyObject.getRuntime())).isTrue()) {
                    rubyString = iRubyObject.getRuntime().newString("-");
                    iRubyObject5 = RubyFixnum.zero(iRubyObject.getRuntime()).callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject7);
                } else {
                    rubyString = iRubyObject.getRuntime().newString("+");
                    iRubyObject5 = iRubyObject7;
                }
                IRubyObject iRubyObject8 = iRubyObject5.callMethod(threadContext, "/", iRubyObject.getRuntime().newFixnum(60)).callMethod(threadContext, "round");
                iRubyObject4 = iRubyObject.getRuntime().newString("%s%02d:%02d").callMethod(threadContext, "%", iRubyObject.getRuntime().newArrayNoCopy(new IRubyObject[]{rubyString, iRubyObject8.callMethod(threadContext, "/", iRubyObject.getRuntime().newFixnum(60)), iRubyObject8.callMethod(threadContext, "%", iRubyObject.getRuntime().newFixnum(60))}));
            }
            iRubyObject3 = iRubyObject.callMethod(threadContext, "strftime", iRubyObject.getRuntime().newString("%Y-%m-%d %H:%M:%S"));
            if (iRubyObject.callMethod(threadContext, "usec").callMethod(threadContext, "nonzero?").isTrue()) {
                iRubyObject3 = iRubyObject3.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject.getRuntime().newString(".%06d").callMethod(threadContext, "%", iRubyObject.getRuntime().newArray(iRubyObject.callMethod(threadContext, "usec"))));
            }
            iRubyObject3 = iRubyObject3.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject.getRuntime().newString(" %s").callMethod(threadContext, "%", iRubyObject.getRuntime().newArray(iRubyObject4)));
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject3, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Regexp"})
    public static class YAMLRegexpMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject regexp_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, "inspect"), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Range"})
    public static class YAMLRangeMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject range_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("begin"), iRubyObject.callMethod(threadContext, "begin"));
            rubyHash.put(iRubyObject.getRuntime().newString("end"), iRubyObject.callMethod(threadContext, "end"));
            rubyHash.put(iRubyObject.getRuntime().newString("excl"), iRubyObject.callMethod(threadContext, "exclude_end?"));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Numeric"})
    public static class YAMLNumericMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject numeric_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            String string = iRubyObject.toString();
            if ("Infinity".equals(string)) {
                string = ".Inf";
            } else if ("-Infinity".equals(string)) {
                string = "-.Inf";
            } else if ("NaN".equals(string)) {
                string = ".NaN";
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)iRubyObject.getRuntime().newString(string), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Symbol"})
    public static class YAMLSymbolMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject symbol_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject.callMethod(threadContext, "inspect"), iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject symbol_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("tag:yaml.org,2002:str");
        }
    }

    @JRubyClass(name={"String"})
    public static class YAMLStringMethods {
        @JRubyMethod(name={"is_complex_yaml?"})
        public static IRubyObject string_is_complex(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.callMethod(threadContext, "to_yaml_style").isTrue() || ((List)((Object)iRubyObject.callMethod(threadContext, "to_yaml_properties"))).isEmpty() || AFTER_NEWLINE.matcher(iRubyObject.toString()).find() ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }

        @JRubyMethod(name={"is_binary_data?"})
        public static IRubyObject string_is_binary(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            if (iRubyObject.callMethod(threadContext, MethodIndex.EMPTY_P, "empty?").isTrue()) {
                return iRubyObject.getRuntime().getNil();
            }
            return iRubyObject.toString().indexOf(0) != -1 ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }

        private static JRubyRepresenter into(IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object");
            if (iRubyObject2 != null) {
                return (JRubyRepresenter)((Object)((JavaObject)iRubyObject2).getValue());
            }
            return null;
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject string_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            Ruby ruby = iRubyObject.getRuntime();
            if (iRubyObject.callMethod(threadContext, "is_binary_data?").isTrue()) {
                return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", (IRubyObject)ruby.newString("tag:yaml.org,2002:binary"), ruby.newArray(iRubyObject).callMethod(threadContext, "pack", ruby.newString("m")), ruby.newString("|"));
            }
            if (((List)((Object)iRubyObject.callMethod(threadContext, "to_yaml_properties"))).isEmpty()) {
                JRubyRepresenter jRubyRepresenter = YAMLStringMethods.into(iRubyObject2);
                if (jRubyRepresenter != null) {
                    try {
                        return JavaUtil.convertJavaToRuby(ruby, jRubyRepresenter.scalar(iRubyObject.callMethod(threadContext, "taguri").toString(), iRubyObject.convertToString().getByteList(), iRubyObject.toString().startsWith(":") ? "\"" : iRubyObject.callMethod(threadContext, "to_yaml_style").toString()));
                    }
                    catch (IOException iOException) {
                        throw ruby.newIOErrorFromException(iOException);
                    }
                }
                return RuntimeHelpers.invoke(threadContext, iRubyObject2, "scalar", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.toString().startsWith(":") ? ruby.newString("\"") : iRubyObject.callMethod(threadContext, "to_yaml_style"));
            }
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("str"), ruby.newString(iRubyObject.toString()));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Exception"})
    public static class YAMLExceptionMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject exception_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            rubyHash.put(iRubyObject.getRuntime().newString("message"), iRubyObject.callMethod(threadContext, "message"));
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject exception_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/exception:" + iRubyObject.getType().getName());
        }
    }

    @JRubyClass(name={"Struct"})
    public static class YAMLStructMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject struct_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Object object;
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            Iterator iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "members")).getList().iterator();
            while (iterator.hasNext()) {
                object = iRubyObject.getRuntime().newString(iterator.next().toString());
                rubyHash.put(object, iRubyObject.callMethod(threadContext, MethodIndex.AREF, "[]", (IRubyObject)object));
            }
            iterator = ((RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties")).getList().iterator();
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(((String)object).substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString((String)object)));
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject struct_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/struct:" + iRubyObject.getType().getName());
        }
    }

    @JRubyClass(name={"Array"})
    public static class YAMLArrayMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject array_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "seq", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }

    @JRubyClass(name={"Class"})
    public static class YAMLClassMethods {
        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject class_to_yaml(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            throw iRubyObject.getRuntime().newTypeError("can't dump anonymous class " + iRubyObject.getType().getName());
        }
    }

    @JRubyClass(name={"Object"})
    public static class YAMLObjectMethods {
        @JRubyMethod(name={"to_yaml_properties"})
        public static IRubyObject obj_to_yaml_properties(IRubyObject iRubyObject) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.callMethod(threadContext, "instance_variables").callMethod(threadContext, "sort");
        }

        @JRubyMethod(name={"to_yaml_style"})
        public static IRubyObject obj_to_yaml_style(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject obj_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            RubyHash rubyHash = new RubyHash(iRubyObject.getRuntime());
            RubyArray rubyArray = (RubyArray)iRubyObject.callMethod(threadContext, "to_yaml_properties");
            Iterator iterator = rubyArray.getList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                rubyHash.put(iRubyObject.getRuntime().newString(string.substring(1)), iRubyObject.callMethod(threadContext, "instance_variable_get", iRubyObject.getRuntime().newString(string)));
            }
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), (IRubyObject)rubyHash, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }

        @JRubyMethod(name={"to_yaml"}, rest=true)
        public static IRubyObject obj_to_yaml(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
            return iRubyObject.getRuntime().fastGetModule("YAML").callMethod(threadContext, "dump", iRubyObject);
        }

        @JRubyMethod(name={"taguri"})
        public static IRubyObject obj_taguri(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("!ruby/object:" + iRubyObject.getType().getName());
        }
    }

    @JRubyClass(name={"Hash"})
    public static class YAMLHashMethods {
        @JRubyMethod(name={"to_yaml_node"}, required=1)
        public static IRubyObject hash_to_yaml_node(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = iRubyObject.getRuntime();
            ThreadContext threadContext = ruby.getCurrentContext();
            return RuntimeHelpers.invoke(threadContext, iRubyObject2, "map", iRubyObject.callMethod(threadContext, "taguri"), iRubyObject, iRubyObject.callMethod(threadContext, "to_yaml_style"));
        }
    }
}

