/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jruby.nb.RubyThread;
import org.jruby.nb.internal.runtime.RubyRunnable;
import org.jruby.nb.internal.runtime.ThreadLike;

public class FutureThread
implements ThreadLike {
    private volatile Future future;
    private RubyRunnable runnable;
    public RubyThread rubyThread;

    public FutureThread(RubyThread rubyThread, RubyRunnable rubyRunnable) {
        this.rubyThread = rubyThread;
        this.runnable = rubyRunnable;
    }

    public void start() {
        this.future = this.rubyThread.getRuntime().getExecutor().submit(this.runnable);
    }

    public void interrupt() {
        if (this.runnable.getJavaThread() != null) {
            this.runnable.getJavaThread().interrupt();
        }
    }

    public boolean isAlive() {
        return this.future == null || !this.future.isDone();
    }

    public void join() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void join(long l) throws InterruptedException, ExecutionException {
        if (l == 0L) {
            this.join();
        } else {
            try {
                this.future.get(l, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException cancellationException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    public int getPriority() {
        return 1;
    }

    public void setPriority(int n) {
    }

    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    public boolean isInterrupted() {
        return this.future.isCancelled();
    }
}

