/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.proxies;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class JavaProxy
extends RubyObject {
    public JavaProxy(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createJavaProxy(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        RubyClass rubyClass = ruby.defineClass("JavaProxy", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new JavaProxy(ruby, rubyClass);
            }
        });
        RubyClass rubyClass2 = rubyClass.getSingletonClass();
        rubyClass2.addReadWriteAttribute(threadContext, "java_class");
        rubyClass.defineAnnotatedMethods(JavaProxy.class);
        rubyClass.includeModule(ruby.fastGetModule("JavaProxyMethods"));
        return rubyClass;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = RuntimeHelpers.invoke(threadContext, iRubyObject2, "java_class");
        if (iRubyObject3.isNil()) {
            iRubyObject3 = RuntimeHelpers.invoke(threadContext, iRubyObject, "java_class");
            RuntimeHelpers.invoke(threadContext, iRubyObject2, "java_class=", iRubyObject3);
        }
        return iRubyObject.callSuper(threadContext, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject iRubyObject) {
        return ((RubyClass)iRubyObject).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = RuntimeHelpers.invoke(threadContext, iRubyObject, "java_class");
        if (iRubyObjectArray.length > 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
            iRubyObjectArray2[0] = iRubyObject2;
            System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 1, iRubyObjectArray.length);
            return threadContext.getRuntime().fastGetClass("ArrayJavaProxyCreator").newInstance(threadContext, iRubyObjectArray2, Block.NULL_BLOCK);
        }
        return Java.get_proxy_class(iRubyObject2, RuntimeHelpers.invoke(threadContext, iRubyObject2, "array_class"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_instance_for(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.new_instance_for(iRubyObject, iRubyObject2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject to_java_object(IRubyObject iRubyObject) {
        return Java.to_java_object(iRubyObject);
    }

    public Object unwrap() {
        return ((JavaObject)this.dataGetStruct()).getValue();
    }
}

