/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectStatementAnalyzer
extends SQLStatementAnalyzer {
    private final List<List<String>> selectValues = new ArrayList<List<String>>();
    private final List<SQLStatementAnalyzer.TableIdent> fromTables = new ArrayList<SQLStatementAnalyzer.TableIdent>();

    public static SelectStatement analyze(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        SelectStatementAnalyzer selectStatementAnalyzer = new SelectStatementAnalyzer(tokenSequence, quoter);
        selectStatementAnalyzer.parse();
        TablesClause tablesClause = selectStatementAnalyzer.context.isAfter(SQLStatement.Context.FROM) ? selectStatementAnalyzer.createTablesClause(selectStatementAnalyzer.fromTables) : null;
        return new SelectStatement(selectStatementAnalyzer.startOffset, tokenSequence.offset() + tokenSequence.token().length(), Collections.unmodifiableList(selectStatementAnalyzer.selectValues), tablesClause, Collections.unmodifiableList(selectStatementAnalyzer.subqueries), selectStatementAnalyzer.offset2Context);
    }

    private SelectStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        super(tokenSequence, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        boolean bl = false;
        block21: do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("SELECT", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.SELECT);
                    break;
                }
                case SELECT: {
                    Object object;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            object = this.analyzeSelectValue();
                            if (object.isEmpty()) break;
                            this.selectValues.add((List<String>)object);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("FROM", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.FROM);
                            bl = true;
                        }
                    }
                    continue block21;
                }
                case FROM: {
                    Object object;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            if (!bl) break;
                            object = this.parseTableIdent();
                            if (object != null) {
                                this.fromTables.add((SQLStatementAnalyzer.TableIdent)object);
                            }
                            bl = false;
                            break;
                        }
                        case COMMA: {
                            bl = true;
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("JOIN", (TokenSequence<SQLTokenId>)this.seq)) {
                                bl = true;
                                break;
                            }
                            object = this.getContextForKeywordAfterFrom();
                            if (object == null) break;
                            this.moveToContext((SQLStatement.Context)((Object)object));
                        }
                    }
                    continue block21;
                }
                case JOIN_CONDITION: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case COMMA: {
                            this.moveToContext(SQLStatement.Context.FROM);
                            bl = true;
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("JOIN", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.FROM);
                            bl = true;
                        }
                    }
                    continue block21;
                }
                case GROUP: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.GROUP_BY);
                    break;
                }
                case ORDER: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.ORDER_BY);
                    break;
                }
                default: {
                    Object object = this.getContextForKeywordAfterFrom();
                    if (object == null) continue block21;
                    this.moveToContext((SQLStatement.Context)((Object)object));
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeSelectValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        boolean bl = false;
        block7: while (true) {
            if (!this.nextToken()) {
                return arrayList;
            }
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block7;
                }
                case IDENTIFIER: {
                    if (bl) {
                        bl = false;
                        arrayList.add(this.getUnquotedIdentifier());
                        continue block7;
                    }
                    arrayList.clear();
                    arrayList.add(this.getUnquotedIdentifier());
                    continue block7;
                }
                case LPAREN: {
                    arrayList.clear();
                    continue block7;
                }
                case COMMA: {
                    break block7;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", (TokenSequence<SQLTokenId>)this.seq)) {
                        bl = false;
                        arrayList.clear();
                        continue block7;
                    }
                    if (!SQLStatementAnalyzer.isKeyword("FROM", (TokenSequence<SQLTokenId>)this.seq) && !this.isKeywordAfterFrom()) continue block7;
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        this.seq.movePrevious();
        return arrayList;
    }

    private boolean isKeywordAfterFrom() {
        return this.getContextForKeywordAfterFrom() != null;
    }

    private SQLStatement.Context getContextForKeywordAfterFrom() {
        if (SQLStatementAnalyzer.isKeyword("ON", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.JOIN_CONDITION;
        }
        if (SQLStatementAnalyzer.isKeyword("WHERE", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.WHERE;
        }
        if (SQLStatementAnalyzer.isKeyword("GROUP", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.GROUP;
        }
        if (SQLStatementAnalyzer.isKeyword("HAVING", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.HAVING;
        }
        if (SQLStatementAnalyzer.isKeyword("ORDER", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.ORDER;
        }
        return null;
    }
}

