/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation {
    private static Collection<Validator> ourValidators;
    private List<Model> myValidatedModels;
    private List<Validator.ResultItem> myValidationResult = new ArrayList<Validator.ResultItem>();
    private static boolean isStopped;

    public Validation() {
        this.myValidatedModels = new ArrayList<Model>();
    }

    public void validate(Model model, ValidationType validationType) {
        Object object;
        isStopped = false;
        if (this.myValidatedModels.contains(model)) {
            return;
        }
        this.myValidatedModels.add(model);
        for (Validator object22 : ourValidators) {
            if (isStopped) {
                this.myValidationResult = null;
                this.myValidatedModels = new ArrayList<Model>();
                break;
            }
            object = object22.validate(model, this, validationType);
            if (object == null) continue;
            this.myValidationResult.addAll(((ValidationResult)object).getValidationResult());
            this.myValidatedModels.addAll(((ValidationResult)object).getValidatedModels());
        }
        LinkedList linkedList = new LinkedList();
        LinkedList<Validator.ResultItem> linkedList2 = new LinkedList<Validator.ResultItem>();
        object = new LinkedList();
        if (this.myValidationResult == null) {
            this.myValidationResult = new ArrayList<Validator.ResultItem>();
            return;
        }
        for (Validator.ResultItem resultItem : this.myValidationResult) {
            if (resultItem.getType() == Validator.ResultType.ERROR) {
                linkedList.add(resultItem);
                continue;
            }
            if (resultItem.getType() == Validator.ResultType.ADVICE) {
                linkedList2.add(resultItem);
                continue;
            }
            if (resultItem.getType() != Validator.ResultType.WARNING) continue;
            object.add(resultItem);
        }
        this.myValidationResult = new LinkedList<Validator.ResultItem>();
        this.myValidationResult.addAll((Collection<Validator.ResultItem>)object);
        this.myValidationResult.addAll(linkedList2);
        this.myValidationResult.addAll(linkedList);
    }

    public List<Validator.ResultItem> getValidationResult() {
        if (this.myValidationResult == null) {
            return null;
        }
        return Collections.unmodifiableList(this.myValidationResult);
    }

    public List<Model> getValidatedModels() {
        return Collections.unmodifiableList(this.myValidatedModels);
    }

    private static void lookupProviders() {
        if (ourValidators != null) {
            return;
        }
        ourValidators = new ArrayList<Validator>();
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(Validator.class));
        for (Object e : result.allInstances()) {
            ourValidators.add((Validator)e);
        }
    }

    public static void stop() {
        isStopped = true;
    }

    static {
        Validation.lookupProviders();
        isStopped = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationType {
        COMPLETE,
        PARTIAL;

    }
}

