/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.netbeans.modules.websvc.saas.ui.actions.ViewWSDLAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.ui.nodes.WsdlSaasNodeChildren;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WsdlSaasNode
extends SaasNode {
    ExTransferable transferable;
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/webservice.png");
    private boolean portAdded;

    public WsdlSaasNode(WsdlSaas wsdlSaas) {
        this(wsdlSaas, new InstanceContent());
    }

    protected WsdlSaasNode(WsdlSaas wsdlSaas, InstanceContent instanceContent) {
        super(new WsdlSaasNodeChildren(wsdlSaas), new AbstractLookup((AbstractLookup.Content)instanceContent), (Saas)wsdlSaas);
        instanceContent.add((Object)wsdlSaas);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)wsdlSaas, SaasTransferable.WSDL_SERVICE_FLAVORS));
    }

    private static WsdlSaasPort getDefaultPort(WsdlSaas wsdlSaas) {
        if (wsdlSaas.getPorts().isEmpty()) {
            return null;
        }
        return (WsdlSaasPort)wsdlSaas.getPorts().get(0);
    }

    public WsdlSaas getSaas() {
        return (WsdlSaas)super.getSaas();
    }

    public Image getGenericIcon(int n) {
        return ICON;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions(bl)));
        arrayList.add((Action)SystemAction.get(ViewWSDLAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("data");
        if (set == null) {
            set = new Sheet.Set();
            set.setName("data");
            set.setDisplayName(NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_INFO"));
            set.setShortDescription(NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_INFO"));
            sheet.put(set);
        }
        set.put((Node.Property)new PropertySupport.ReadOnly("name", String.class, NbBundle.getMessage(WsdlSaasNode.class, (String)"PORT_NAME_IN_WSDL"), NbBundle.getMessage(WsdlSaasNode.class, (String)"PORT_NAME_IN_WSDL")){

            public Object getValue() {
                return this.getName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("URL", String.class, NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_URL"), NbBundle.getMessage(WsdlSaasNode.class, (String)"WS_URL")){

            public Object getValue() {
                return WsdlSaasNode.this.saas.getUrl();
            }
        });
        return sheet;
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.getSaas().getState() != Saas.State.READY) {
            this.getSaas().toStateReady(true);
            return super.clipboardCopy();
        }
        if (!this.portAdded) {
            final WsdlSaasPort wsdlSaasPort = WsdlSaasNode.getDefaultPort(this.getSaas());
            if (wsdlSaasPort != null) {
                this.transferable.put(new ExTransferable.Single(ConsumerFlavorProvider.PORT_FLAVOR){

                    protected Object getData() throws IOException, UnsupportedFlavorException {
                        return wsdlSaasPort;
                    }
                });
            }
            this.portAdded = true;
        }
        return SaasTransferable.addFlavors((Transferable)this.transferable);
    }
}

