/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.maven;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Contributor;
import org.netbeans.modules.maven.model.pom.Developer;
import org.netbeans.modules.maven.model.pom.IssueManagement;
import org.netbeans.modules.maven.model.pom.License;
import org.netbeans.modules.maven.model.pom.MailingList;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Scm;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class KenaiUpdateAction
extends AbstractAction
implements ContextAwareAction,
TaskListener {
    private Lookup context;
    private String uri;
    private RequestProcessor.Task updateTask;
    private static final String POM_SCM = "scm";
    private static final String POM_DELIM = ":";
    private static final String POM_HG = "hg";
    private static final String POM_SVN = "svn";
    private static final String POM_EXTERNAL = "???";
    private static final String KENAI_SITE = ".kenai.com";
    private static final String KENAI_SYMPA = "sympa@";
    private static final String KENAI_SUBSCRIBE = "?subject=sub%20";
    private static final String KENAI_UNSUBSCRIBE = "?subject=unsub%20";

    public KenaiUpdateAction() {
        this.putValue("Name", NbBundle.getMessage(KenaiUpdateAction.class, (String)"CTL_KenaiUpdateAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(KenaiUpdateAction.class, (String)"TIP_KenaiUpdateAction"));
    }

    public KenaiUpdateAction(Lookup lookup) {
        this();
        this.context = lookup;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        FileObject fileObject = (FileObject)this.context.lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        Object object = fileObject.getAttribute("ProvidedExtensions.RemoteLocation");
        if (object == null || !(object instanceof String)) {
            return false;
        }
        this.uri = (String)object;
        return KenaiUpdateAction.isKenai(this.uri);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.updateTask != null) {
            return;
        }
        this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                KenaiUpdateAction.this.doPerformAction();
            }
        });
        this.updateTask.addTaskListener((TaskListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPerformAction() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiUpdateAction.class, (String)"LBL_UpdateProgress"));
        try {
            String string;
            progressHandle.start(4);
            FileObject fileObject = (FileObject)this.context.lookup(FileObject.class);
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject);
            POMModel pOMModel = null;
            if (modelSource.isEditable()) {
                pOMModel = POMModelFactory.getDefault().getModel(modelSource);
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_NotEditable"));
            }
            progressHandle.progress(1);
            KenaiProject kenaiProject = null;
            try {
                kenaiProject = KenaiProject.forRepository((String)this.uri);
            }
            catch (KenaiException kenaiException) {
                string = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_NoProject");
                StatusDisplayer.getDefault().setStatusText(string);
                Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, string, kenaiException);
            }
            progressHandle.progress(2);
            if (pOMModel != null && kenaiProject != null) {
                try {
                    KenaiUpdateAction.performUpdate(pOMModel, kenaiProject);
                }
                catch (KenaiException kenaiException) {
                    string = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_UpdateFail");
                    StatusDisplayer.getDefault().setStatusText(string);
                    Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, string, kenaiException);
                }
            }
            progressHandle.progress(3);
            try {
                Utilities.saveChanges((AbstractDocumentModel)pOMModel);
            }
            catch (IOException iOException) {
                string = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_SaveFail");
                StatusDisplayer.getDefault().setStatusText(string);
                Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, string, iOException);
            }
        }
        finally {
            progressHandle.finish();
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new KenaiUpdateAction(lookup);
    }

    private static boolean isKenai(String string) {
        return KenaiProject.getNameForRepository((String)string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performUpdate(POMModel pOMModel, KenaiProject kenaiProject) throws KenaiException {
        try {
            pOMModel.startTransaction();
            Project project = pOMModel.getProject();
            POMComponentFactory pOMComponentFactory = pOMModel.getFactory();
            project.setName(kenaiProject.getDisplayName());
            project.setDescription(kenaiProject.getDescription());
            project.setURL(kenaiProject.getWebLocation().toExternalForm());
            KenaiLicense[] kenaiLicenseArray = kenaiProject.getLicenses();
            for (int i = 0; i < kenaiLicenseArray.length; ++i) {
                KenaiUpdateAction.updateLicense(project, kenaiLicenseArray[i], pOMComponentFactory);
            }
            KenaiProjectMember[] kenaiProjectMemberArray = kenaiProject.getMembers();
            for (int i = 0; i < kenaiProjectMemberArray.length; ++i) {
                KenaiUpdateAction.updateMember(project, kenaiProjectMemberArray[i], pOMComponentFactory);
            }
            KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures();
            block10: for (int i = 0; i < kenaiFeatureArray.length; ++i) {
                KenaiFeature kenaiFeature = kenaiFeatureArray[i];
                switch (kenaiFeature.getType()) {
                    case SOURCE: {
                        Scm scm = project.getScm();
                        if (scm == null) {
                            scm = pOMComponentFactory.createScm();
                            project.setScm(scm);
                        }
                        KenaiUpdateAction.updateScm(scm, kenaiFeature);
                        continue block10;
                    }
                    case ISSUES: {
                        IssueManagement issueManagement = project.getIssueManagement();
                        if (issueManagement == null) {
                            issueManagement = pOMComponentFactory.createIssueManagement();
                            project.setIssueManagement(issueManagement);
                        }
                        KenaiUpdateAction.updateIssueMng(issueManagement, kenaiFeature);
                        continue block10;
                    }
                    case LISTS: {
                        KenaiUpdateAction.updateLists(project, kenaiFeature, pOMComponentFactory, kenaiProject);
                    }
                }
            }
        }
        finally {
            pOMModel.endTransaction();
        }
    }

    private static void updateScm(Scm scm, KenaiFeature kenaiFeature) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(POM_SCM);
        stringBuilder.append(POM_DELIM);
        String string = kenaiFeature.getName();
        if ("subversion".equals(string)) {
            stringBuilder.append(POM_SVN);
        } else if ("mercurial".equals(string)) {
            stringBuilder.append(POM_HG);
        } else if ("external_repository".equals(string)) {
            stringBuilder.append(POM_EXTERNAL);
        }
        stringBuilder.append(POM_DELIM);
        stringBuilder.append(kenaiFeature.getLocation());
        String string2 = stringBuilder.toString();
        scm.setConnection(string2);
        scm.setDeveloperConnection(string2);
        scm.setUrl(kenaiFeature.getWebLocation().toExternalForm());
    }

    private static void updateIssueMng(IssueManagement issueManagement, KenaiFeature kenaiFeature) {
        issueManagement.setSystem(kenaiFeature.getService());
        issueManagement.setUrl(kenaiFeature.getLocation());
    }

    private static void updateLists(Project project, KenaiFeature kenaiFeature, POMComponentFactory pOMComponentFactory, KenaiProject kenaiProject) {
        Object object2;
        List list = project.getMailingLists();
        MailingList mailingList = null;
        if (list != null) {
            for (Object object2 : list) {
                if (object2.getName() == null || !object2.getName().equals(kenaiFeature.getName())) continue;
                mailingList = object2;
                break;
            }
        }
        if (mailingList == null) {
            mailingList = pOMComponentFactory.createMailingList();
            project.addMailingList(mailingList);
        }
        mailingList.setName(kenaiFeature.getName());
        mailingList.setArchive(kenaiFeature.getWebLocation().toExternalForm());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(kenaiFeature.getName());
        stringBuilder.append('@');
        stringBuilder.append(kenaiProject.getName());
        stringBuilder.append(KENAI_SITE);
        mailingList.setPost(stringBuilder.toString());
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append(KENAI_SYMPA);
        stringBuilder.append(kenaiProject.getName());
        stringBuilder.append(KENAI_SITE);
        object2 = new StringBuilder();
        ((StringBuilder)object2).append((CharSequence)stringBuilder);
        stringBuilder.append(KENAI_SUBSCRIBE);
        stringBuilder.append(kenaiFeature.getName());
        ((StringBuilder)object2).append(KENAI_UNSUBSCRIBE);
        ((StringBuilder)object2).append(kenaiFeature.getName());
        mailingList.setSubscribe(stringBuilder.toString());
        mailingList.setUnsubscribe(((StringBuilder)object2).toString());
    }

    private static void updateLicense(Project project, KenaiLicense kenaiLicense, POMComponentFactory pOMComponentFactory) {
        List list = project.getLicenses();
        License license = null;
        if (list != null) {
            for (License license2 : list) {
                if (license2.getName() == null || !license2.getName().equals(kenaiLicense.getName())) continue;
                license = license2;
                break;
            }
        }
        if (license == null) {
            license = pOMComponentFactory.createLicense();
            project.addLicense(license);
        }
        license.setName(kenaiLicense.getName());
        license.setUrl(kenaiLicense.getUri().toString());
        license.setComments(kenaiLicense.getDisplayName());
    }

    private static void updateMember(Project project, KenaiProjectMember kenaiProjectMember, POMComponentFactory pOMComponentFactory) {
        String string = kenaiProjectMember.getKenaiUser().getFirstName() + " " + kenaiProjectMember.getKenaiUser().getLastName();
        if (KenaiProjectMember.Role.OBSERVER.equals((Object)kenaiProjectMember.getRole())) {
            Object object2;
            List list = project.getContributors();
            Contributor contributor = null;
            if (list != null) {
                for (Object object2 : list) {
                    if (!string.equalsIgnoreCase(object2.getName())) continue;
                    contributor = object2;
                    break;
                }
            }
            if (contributor == null) {
                contributor = pOMComponentFactory.createContributor();
                project.addContributor(contributor);
            }
            contributor.setName(string);
            String string2 = kenaiProjectMember.getRole().name().toLowerCase();
            object2 = contributor.getRoles();
            boolean bl = false;
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (!string3.equals(string2)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                contributor.addRole(string2);
            }
        } else {
            Object object3;
            List list = project.getDevelopers();
            Developer developer = null;
            if (list != null) {
                for (Object object3 : list) {
                    if (!object3.getId().equalsIgnoreCase(kenaiProjectMember.getUserName())) continue;
                    developer = object3;
                    break;
                }
            }
            if (developer == null) {
                developer = pOMComponentFactory.createDeveloper();
                project.addDeveloper(developer);
            }
            developer.setId(kenaiProjectMember.getUserName());
            developer.setName(string);
            String string4 = kenaiProjectMember.getRole().name().toLowerCase();
            object3 = developer.getRoles();
            boolean bl = false;
            if (object3 != null) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (!string5.equals(string4)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                developer.addRole(string4);
            }
        }
    }

    public void taskFinished(Task task) {
        this.updateTask = null;
    }
}

