/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageViewer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class ImageOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    private long lastSaveTime;
    private FileChangeListener fileChangeL;
    private RequestProcessor.Task reloadTask;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public ImageOpenSupport(MultiDataObject.Entry entry) {
        super(entry, (OpenSupport.Env)new Environment((DataObject)entry.getDataObject()));
    }

    public CloneableTopComponent createCloneableTopComponent() {
        this.prepareViewer();
        return new ImageViewer((ImageDataObject)this.entry.getDataObject());
    }

    void prepareViewer() {
        if (this.fileChangeL == null) {
            this.fileChangeL = new FileChangeAdapter(){

                public void fileChanged(final FileEvent fileEvent) {
                    if (ImageOpenSupport.this.allEditors.isEmpty()) {
                        return;
                    }
                    if (fileEvent.getFile().isVirtual()) {
                        ImageOpenSupport.this.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                        ((Environment)ImageOpenSupport.this.env).fileRemoved();
                        ImageOpenSupport.this.entry.getFile().addFileChangeListener((FileChangeListener)this);
                        return;
                    }
                    if (fileEvent.getTime() > ImageOpenSupport.this.lastSaveTime) {
                        ImageOpenSupport.this.lastSaveTime = System.currentTimeMillis();
                        if (ImageOpenSupport.this.reloadTask == null || ImageOpenSupport.this.reloadTask.isFinished()) {
                            ImageOpenSupport.this.reloadTask = RequestProcessor.getDefault().post(new Runnable(){

                                public void run() {
                                    ImageOpenSupport.this.reload(fileEvent);
                                }
                            });
                        }
                    }
                }
            };
        }
        this.entry.getFile().addFileChangeListener(this.fileChangeL);
        this.lastSaveTime = System.currentTimeMillis();
    }

    void lastClosed() {
        if (this.fileChangeL != null) {
            this.entry.getFile().removeFileChangeListener(this.fileChangeL);
            this.fileChangeL = null;
        }
    }

    private void reload(FileEvent fileEvent) {
        String string = NbBundle.getMessage((Class)ImageOpenSupport.class, (String)"MSG_ExternalChange", (Object)this.entry.getFile());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (NotifyDescriptor.YES_OPTION.equals(object)) {
            final ImageDataObject imageDataObject = (ImageDataObject)this.entry.getDataObject();
            CloneableTopComponent.Ref ref = this.allEditors;
            Enumeration enumeration = ref.getComponents();
            while (enumeration.hasMoreElements()) {
                final Object e = enumeration.nextElement();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((ImageViewer)((Object)e)).updateView(imageDataObject);
                    }
                });
            }
        }
    }

    private static class Environment
    extends OpenSupport.Env {
        static final long serialVersionUID = -1934890789745432254L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ImageOpenSupport.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

