/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.IOException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.StrTerm;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.lexer.Token;
import org.jrubyparser.util.CStringBuilder;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags, int begin, int end) {
        this.flags = flags;
        this.begin = (char)begin;
        this.end = (char)end;
        this.nest = 0;
    }

    public int parseString(Lexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 372;
        }
        int c = src.read();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = src.read())) {
            }
            spaceSeen = true;
        }
        if ((this.processingEmbedded == 0 || this.processingEmbedded == 1) && c == this.end && this.nest == 0) {
            if ((this.flags & 8) != 0) {
                if (this.processingEmbedded == 1) {
                    lexer.setValue(new Token("" + this.end, lexer.getPosition()));
                    return 372;
                }
                this.flags = -1;
                lexer.getPosition();
                return 32;
            }
            if ((this.flags & 4) != 0) {
                lexer.setValue(new RegexpNode(src.getPosition(), "", this.parseRegexpFlags(src)));
                return 380;
            }
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 372;
        }
        if (spaceSeen) {
            src.unread(c);
            lexer.getPosition();
            return 32;
        }
        if (this.processingEmbedded == 2 && c == 125) {
            this.processingEmbedded = 1;
            lexer.setValue(new Token("}", lexer.getPosition()));
            return 377;
        }
        if (this.begin == '\u0000' && this.flags == 0) {
            CStringBuilder buffer = new CStringBuilder();
            src.unread(c);
            if (this.parseSimpleStringIntoBuffer(src, buffer) == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, src.getPosition(), "unterminated string meets end of file", new Object[0]);
            }
            lexer.setValue(new StrNode(lexer.getPosition(), buffer.toString()));
            return 377;
        }
        CStringBuilder buffer = new CStringBuilder();
        if ((this.flags & 2) != 0 && c == 35) {
            c = src.read();
            switch (c) {
                case 36: 
                case 64: {
                    if (this.processingEmbedded == 1) {
                        this.processingEmbedded = 3;
                    }
                    src.unread(c);
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 371;
                }
                case 123: {
                    if (this.processingEmbedded == 1) {
                        this.processingEmbedded = 2;
                    }
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 370;
                }
            }
            buffer.append(35);
        }
        src.unread(c);
        int parsed = this.processingEmbedded == 2 ? this.parseDExprIntoBuffer(lexer, src, buffer) : this.parseStringIntoBuffer(lexer, src, buffer);
        if (parsed == -1) {
            throw new UnterminatedStringException(src.getPosition(), "unterminated string meets end of file");
        }
        lexer.setValue(new StrNode(lexer.getPosition(), buffer.toString()));
        if (this.processingEmbedded == 3) {
            this.processingEmbedded = 1;
        } else if (this.processingEmbedded == 2 && buffer.length() == 0) {
            this.processingEmbedded = 1;
        }
        return 377;
    }

    private int parseRegexpFlags(LexerSource src) throws IOException {
        int kcode = 0;
        int options = 0;
        CStringBuilder unknownFlags = new CStringBuilder(10);
        int c = src.read();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options |= 1;
                    break;
                }
                case 120: {
                    options |= 2;
                    break;
                }
                case 109: {
                    options |= 4;
                    break;
                }
                case 111: {
                    options |= 0x80;
                    break;
                }
                case 110: {
                    kcode = 16;
                    break;
                }
                case 101: {
                    kcode = 32;
                    break;
                }
                case 115: {
                    kcode = 48;
                    break;
                }
                case 117: {
                    kcode = 64;
                    break;
                }
                case 106: {
                    options |= 0x100;
                    break;
                }
                default: {
                    unknownFlags.append(c);
                }
            }
            c = src.read();
        }
        src.unread(c);
        if (unknownFlags.length() != 0) {
            throw new SyntaxException(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, src.getPosition(), "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString(), unknownFlags.toString());
        }
        return options | kcode;
    }

    public int parseSimpleStringIntoBuffer(LexerSource src, CStringBuilder buffer) throws IOException {
        int c;
        while ((c = src.read()) != -1) {
            if (c == this.end) {
                src.unread(c);
                break;
            }
            if (c == 92 && ((c = src.read()) == 10 || c != this.end) && c != 92) {
                buffer.append(92);
            }
            buffer.append((char)c);
        }
        return c;
    }

    public int parseStringIntoBuffer(Lexer lexer, LexerSource src, CStringBuilder buffer) throws IOException {
        int c;
        boolean regexp;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean bl = regexp = (this.flags & 4) != 0;
        block4: while ((c = src.read()) != -1) {
            block16: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                if (this.begin == '\u0000' || c != this.begin) break block15;
                                ++this.nest;
                                break block16;
                            }
                            if (this.processingEmbedded == 2 && c == 125) {
                                src.unread(c);
                                break;
                            }
                            if (this.processingEmbedded == 3 && c != 95 && c != 36 && c != 64 && !Character.isLetter(c)) {
                                src.unread(c);
                                break;
                            }
                            if (c != this.end) break block17;
                            if (this.nest == 0) {
                                src.unread(c);
                                break;
                            }
                            --this.nest;
                            break block16;
                        }
                        if (c != 35 || !expand || src.peek(10)) break block18;
                        int c2 = src.read();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            src.unread(c2);
                            src.unread(c);
                            break;
                        }
                        src.unread(c2);
                        break block16;
                    }
                    if (c != 92) break block19;
                    c = src.read();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block4;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape) {
                                buffer.append((char)c);
                                break;
                            }
                            break block16;
                        }
                        default: {
                            if (regexp) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                continue block4;
                            }
                            if (expand) {
                                src.unread(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block16;
                        }
                    }
                    break block16;
                }
                if (qwords && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            buffer.append((char)c);
        }
        return c;
    }

    public int parseDExprIntoBuffer(Lexer lexer, LexerSource src, CStringBuilder buffer) throws IOException {
        int c;
        boolean regexp;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean bl = regexp = (this.flags & 4) != 0;
        block4: while ((c = src.read()) != -1) {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (c != 123) break block12;
                            ++this.nest;
                            break block13;
                        }
                        if (c != 125) break block14;
                        if (this.nest == 0) {
                            src.unread(c);
                            break;
                        }
                        --this.nest;
                        break block13;
                    }
                    if (c != 92) break block15;
                    c = src.read();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block4;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape) {
                                buffer.append((char)c);
                                break;
                            }
                            break block13;
                        }
                        default: {
                            if (regexp) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                continue block4;
                            }
                            if (expand) {
                                src.unread(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block13;
                        }
                    }
                    break block13;
                }
                if (qwords && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            buffer.append((char)c);
        }
        return c;
    }

    public boolean isSubstituting() {
        return (this.flags & 2) != 0;
    }

    private void escaped(LexerSource src, CStringBuilder buffer) throws IOException {
        int c = src.read();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                buffer.append((char)c);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource src, CStringBuilder buffer) throws IOException {
        int c = src.read();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append((char)c);
                for (int i = 0; i < 2; ++i) {
                    c = src.read();
                    if (c == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                    }
                    if (!Lexer.isOctChar(c)) {
                        src.unread(c);
                        break block0;
                    }
                    buffer.append((char)c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append((char)c);
                c = src.read();
                if (!Lexer.isHexChar(c)) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append((char)c);
                c = src.read();
                if (Lexer.isHexChar(c)) {
                    buffer.append((char)c);
                    break;
                }
                src.unread(c);
                break;
            }
            case 77: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(src, buffer);
                break;
            }
            case 67: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(src, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append((char)c);
            }
        }
    }

    public Object getMutableState() {
        return new MutableTermState(this.processingEmbedded, this.nest);
    }

    public void setMutableState(Object o) {
        MutableTermState state = (MutableTermState)o;
        if (state != null) {
            this.processingEmbedded = state.processingEmbedded;
            this.nest = state.nest;
        }
    }

    public void splitEmbeddedTokens() {
        if (this.processingEmbedded == 0) {
            this.processingEmbedded = 1;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StringTerm other = (StringTerm)obj;
        return this.flags == other.flags && this.end == other.end && this.begin == other.begin && this.processingEmbedded == other.processingEmbedded && this.nest == other.nest;
    }

    private static String toFuncString(int flags) {
        String string;
        CStringBuilder builder = new CStringBuilder();
        if ((flags & 1) != 0) {
            builder.append("escape|");
        }
        if ((flags & 2) != 0) {
            builder.append("expand|");
        }
        if ((flags & 4) != 0) {
            builder.append("regexp|");
        }
        if ((flags & 8) != 0) {
            builder.append("qwords|");
        }
        if ((flags & 0x10) != 0) {
            builder.append("symbol|");
        }
        if ((flags & 0x20) != 0) {
            builder.append("indent|");
        }
        if ((string = builder.toString()).endsWith("|")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            string = "-";
        }
        return string;
    }

    public String toString() {
        return "StringTerm[flags=" + StringTerm.toFuncString(this.flags) + ",end=" + this.end + ",begin=" + this.begin + ",nest=" + this.nest + ",embed=" + this.processingEmbedded + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + this.flags;
        hash = 13 * hash + this.end;
        hash = 13 * hash + this.begin;
        hash = 13 * hash + this.nest;
        hash = 13 * hash + this.processingEmbedded;
        return hash;
    }

    public static class UnterminatedStringException
    extends SyntaxException {
        public UnterminatedStringException(SourcePosition pos, String message) {
            super(SyntaxException.PID.STRING_HITS_EOF, pos, message, new Object[0]);
        }
    }

    private class MutableTermState {
        private int nest;
        private int processingEmbedded;

        private MutableTermState(int embeddedCode, int nest) {
            this.processingEmbedded = embeddedCode;
            this.nest = nest;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MutableTermState other = (MutableTermState)obj;
            if (this.nest != other.nest) {
                return false;
            }
            return this.processingEmbedded == other.processingEmbedded;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + this.nest;
            hash = 83 * hash + this.processingEmbedded;
            return hash;
        }

        public String toString() {
            return "StringTermState[nest=" + this.nest + ",embed=" + this.processingEmbedded + "]";
        }
    }
}

