/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.openide.util.NbBundle;

public class StepsPanelComponent
extends JPanel {
    private final ResourceBundle messages = ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/components/Bundle");
    private final String STEP = this.messages.getString("STEP");
    private final String WARNINGS = this.messages.getString("WARNINGS");
    private final String NOTES = this.messages.getString("NOTES");
    private final String WARNING = this.messages.getString("WARNING");
    private final String NOTE = this.messages.getString("NOTE");
    private final String EMPTY_HINT = "<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n";
    private final int LOCATION_TOP = 1;
    private final int LOCATION_MIDDLE = 2;
    private final int LOCATION_BOTTOM = 3;
    private boolean warningsFirst = true;
    private boolean isLabelHidden = false;
    private double lastLabelHeight = -1.0;
    private HTMLTextArea areaSteps;
    private JTextArea label;
    private HTMLLabel labelHints;
    private JScrollPane stepsScroller;
    private IntegrationProvider.IntegrationHints steps;

    public StepsPanelComponent() {
        this.initComponents();
    }

    private void initComponents() {
        this.label = new JTextArea();
        this.stepsScroller = new JScrollPane();
        this.areaSteps = new HTMLTextArea();
        this.labelHints = new HTMLLabel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(400, 200));
        this.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this.label.setEditable(false);
        this.label.setLineWrap(true);
        this.label.setText(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.label.text"));
        this.label.setWrapStyleWord(true);
        this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Label.foreground"));
        this.label.setEnabled(false);
        this.label.setOpaque(false);
        this.add((Component)this.label, "North");
        this.stepsScroller.setViewportView((Component)this.areaSteps);
        this.areaSteps.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent_areaSteps.accessibleName"));
        this.add((Component)this.stepsScroller, "Center");
        this.labelHints.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.labelHints.setText(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.labelHints.text"));
        this.labelHints.setAutoscrolls(true);
        this.labelHints.setMaximumSize(new Dimension(300, 100));
        this.labelHints.setMinimumSize(new Dimension(300, 0));
        this.labelHints.setPreferredSize(new Dimension(300, 0));
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        this.labelHints.setDisabledTextColor(Color.darkGray);
        this.labelHints.setBackground(color2);
        this.add((Component)this.labelHints, "South");
        this.labelHints.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.labelHints.AccessibleContext.accessibleName"));
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String string) {
        this.label.setText(string);
    }

    public IntegrationProvider.IntegrationHints getSteps() {
        return this.steps;
    }

    public void setSteps(IntegrationProvider.IntegrationHints integrationHints) {
        this.steps = integrationHints;
        if (integrationHints == null) {
            this.areaSteps.setText("");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (integrationHints.isWarningsFirst()) {
            this.appendWarnings(stringBuffer);
        }
        this.appendSteps(stringBuffer);
        if (!integrationHints.isWarningsFirst()) {
            this.appendWarnings(stringBuffer);
        }
        this.appendHints(stringBuffer);
        stringBuffer.append("<br>");
        this.areaSteps.setText(stringBuffer.toString());
        this.areaSteps.setCaretPosition(0);
    }

    private void appendHints(StringBuffer stringBuffer) {
        if (this.steps.getHints().size() > 0) {
            this.exportAsHtmlList(this.steps.getHints(), this.NOTE, true, stringBuffer);
        }
    }

    private void appendWarnings(StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = !this.steps.isWarningsFirst() && this.steps.getHints().size() == 0;
        if (this.steps.getWarnings().size() > 0) {
            this.exportAsHtmlList(this.steps.getWarnings(), this.WARNING, "#594FBF", bl, stringBuffer);
        }
    }

    private void appendSteps(StringBuffer stringBuffer) {
        boolean bl = this.steps.isWarningsFirst() && this.steps.getHints().size() == 0 || this.steps.getHints().size() == 0 && this.steps.getWarnings().size() == 0;
        this.exportAsHtmlList(this.steps.getSteps(), this.STEP, bl, stringBuffer);
    }

    private void exportAsHtmlList(List list, String string, boolean bl, StringBuffer stringBuffer) {
        this.exportAsHtmlList(list, string, null, bl, stringBuffer);
    }

    private void exportAsHtmlList(List list, String string, String string2, boolean bl, StringBuffer stringBuffer) {
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("<p>").append("<b>").append(MessageFormat.format(string, new Integer(n++))).append("</b>").append(" ");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(iterator.next()).append("</p>");
            if (string2 != null) {
                stringBuffer.append("<span style='color:").append(string2).append("'>").append(stringBuffer2).append("</span>");
                continue;
            }
            stringBuffer.append(stringBuffer2);
        }
        if (!bl) {
            stringBuffer.append("<br><hr>");
        }
    }

    public String getHintText() {
        return this.labelHints.getText();
    }

    public void setHintText(String string) {
        this.labelHints.setText(string);
        if (string == null || string.length() == 0 || this.labelHints.getText().equals("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n")) {
            this.labelHints.setVisible(false);
        } else {
            this.labelHints.setVisible(true);
        }
        this.revalidate();
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.areaSteps.addHyperlinkListener(hyperlinkListener);
    }
}

