/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexingBridge {
    private static final Logger LOG = Logger.getLogger(IndexingBridge.class.getName());
    private static IndexingBridge instance = null;
    private int delayBeforeRefresh = -1;
    private static final int DEFAULT_DELAY = 100;

    public static synchronized IndexingBridge getInstance() {
        if (instance == null) {
            instance = new IndexingBridge();
        }
        return instance;
    }

    public <T> T runWithoutIndexing(Callable<T> callable, File ... fileArray) throws Exception {
        return this.runWithoutIndexing(callable, true, fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithoutIndexing(Callable<T> callable, boolean bl, File ... fileArray) throws Exception {
        HashSet<File> hashSet;
        T t;
        IndexingBridgeProvider indexingBridgeProvider = (IndexingBridgeProvider)Lookup.getDefault().lookup(IndexingBridgeProvider.class);
        if (indexingBridgeProvider != null) {
            if (LOG.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                if (fileArray != null) {
                    for (File file : fileArray) {
                        stringBuffer.append("\n");
                        stringBuffer.append(file.getAbsolutePath());
                    }
                }
                LOG.fine("running vcs operaton without scheduling for files:" + stringBuffer.toString());
            }
            return indexingBridgeProvider.runWithoutIndexing(callable, fileArray);
        }
        try {
            t = callable.call();
            Object var11_11 = null;
            hashSet = new HashSet<File>();
        }
        catch (Throwable throwable) {
            block9: {
                Object var11_12 = null;
                HashSet<File> hashSet2 = new HashSet<File>();
                for (File file : fileArray) {
                    File file2 = file.getParentFile();
                    if (file2 == null) continue;
                    hashSet2.add(file2);
                    LOG.fine("scheduling for fs refresh: [" + file2 + "]");
                }
                if (!bl || hashSet2.size() <= 0) break block9;
                RequestProcessor.getDefault().post(new Runnable(hashSet2){
                    final /* synthetic */ Set val$parents;
                    {
                        this.val$parents = set;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        long l = System.currentTimeMillis();
                        try {
                            FileUtil.refreshFor((File[])this.val$parents.toArray(new File[this.val$parents.size()]));
                        }
                        finally {
                            LOG.fine(" refreshing " + this.val$parents.size() + " parents took " + (System.currentTimeMillis() - l) + " millis.");
                        }
                    }
                }, this.getDelay());
            }
            throw throwable;
        }
        for (File file : fileArray) {
            File file3 = file.getParentFile();
            if (file3 == null) continue;
            hashSet.add(file3);
            LOG.fine("scheduling for fs refresh: [" + file3 + "]");
        }
        if (bl && hashSet.size() > 0) {
            RequestProcessor.getDefault().post(new /* invalid duplicate definition of identical inner class */, this.getDelay());
        }
        return t;
    }

    public boolean isIndexingInProgress() {
        IndexingBridgeProvider indexingBridgeProvider = (IndexingBridgeProvider)Lookup.getDefault().lookup(IndexingBridgeProvider.class);
        if (indexingBridgeProvider != null) {
            return indexingBridgeProvider.isIndexingInProgress();
        }
        return false;
    }

    private IndexingBridge() {
    }

    private int getDelay() {
        if (this.delayBeforeRefresh == -1) {
            String string = System.getProperty("vcs.fsrefresh.delay", Integer.toString(100));
            int n = 100;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.FINE, null, numberFormatException);
            }
            this.delayBeforeRefresh = n;
        }
        return this.delayBeforeRefresh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexingBridgeProvider {
        public <T> T runWithoutIndexing(Callable<T> var1, File ... var2) throws Exception;

        public boolean isIndexingInProgress();
    }
}

