/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectsView
extends JPanel
implements ExplorerManager.Provider,
VetoableChangeListener {
    private final AbstractNode rootNode;
    private final ExplorerManager em;
    private final ProjectOutlineView view;
    private Node[] selectedNodes;

    public ProjectsView(Map<Project, Set<Project>> map) {
        this.rootNode = new AbstractNode((Children)new ProjectsChildren(map));
        this.em = new ExplorerManager();
        this.view = new ProjectOutlineView();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.view), "Center");
        this.em.addVetoableChangeListener((VetoableChangeListener)this);
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public void addSelectionChangeListener(PropertyChangeListener propertyChangeListener) {
        this.em.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeSelectionChangeListener(PropertyChangeListener propertyChangeListener) {
        this.em.removePropertyChangeListener(propertyChangeListener);
    }

    public Set<Project> getSelectedProjects() {
        Node[] nodeArray;
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Node node : nodeArray = this.selectedNodes) {
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project == null) continue;
            hashSet.add(project);
        }
        return hashSet;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray;
            for (Node node : nodeArray = (Node[])propertyChangeEvent.getNewValue()) {
                if (node instanceof ProjectNode) continue;
                throw new PropertyVetoException("", propertyChangeEvent);
            }
            if (nodeArray.length > 0) {
                this.selectedNodes = nodeArray;
            }
        }
    }

    private final class ProjectNode
    extends AbstractNode {
        static final String PROPERTY_NAME_PATH = "path";
        private final ProjectInformation info;

        public ProjectNode(Project project, Children children) {
            super(children, Lookups.singleton((Object)project));
            this.info = ProjectUtils.getInformation((Project)project);
            this.setProperties();
        }

        private void setProperties() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = Sheet.createPropertiesSet();
            set.put((Node.Property)new LocalPathProperty());
            sheet.put(set);
            this.setSheet(sheet);
        }

        public Image getIcon(int n) {
            return ImageUtilities.icon2Image((Icon)this.info.getIcon());
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        public String getName() {
            return this.info.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LocalPathProperty
        extends PropertySupport.ReadOnly<String> {
            public LocalPathProperty() {
                super(ProjectNode.PROPERTY_NAME_PATH, String.class, ProjectNode.PROPERTY_NAME_PATH, ProjectNode.PROPERTY_NAME_PATH);
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return ((Project)ProjectNode.this.getLookup().lookup(Project.class)).getProjectDirectory().getPath();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectsChildren
    extends Children.Keys<ProjectNode> {
        private Map<Project, Set<Project>> projects;

        public ProjectsChildren(Map<Project, Set<Project>> map) {
            this.projects = map;
        }

        protected Node[] createNodes(ProjectNode projectNode) {
            return new ProjectNode[]{projectNode};
        }

        protected void addNotify() {
            this.refreshKeys();
        }

        public void refreshKeys() {
            Project project = (Project)this.getNode().getLookup().lookup(Project.class);
            Set<Project> set = this.projects.get(project);
            LinkedList<ProjectNode> linkedList = new LinkedList<ProjectNode>();
            for (Project project2 : set) {
                linkedList.add(new ProjectNode(project2, (Children)(this.projects.get(project2).size() == 0 ? LEAF : new ProjectsChildren(this.projects))));
            }
            this.setKeys(linkedList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public T getValue() {
            return null;
        }
    }

    private class ProjectOutlineView
    extends OutlineView {
        public ProjectOutlineView() {
            this.getOutline().setShowHorizontalLines(true);
            this.getOutline().setShowVerticalLines(false);
            this.getOutline().setRootVisible(false);
            this.setVerticalScrollBarPolicy(22);
            this.setHorizontalScrollBarPolicy(30);
            this.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectsView.class, (String)"ACSD_ProjectOutlineView"));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectsView.class, (String)"ACSN_ProjectOutlineView"));
            this.setPopupAllowed(true);
            this.setupColumns();
            this.setDefaultColumnSizes();
        }

        private void setupColumns() {
            Node.Property[] propertyArray = new Node.Property[1];
            String string = NbBundle.getMessage(ProjectsView.class, (String)"LBL_Path");
            String string2 = NbBundle.getMessage(ProjectsView.class, (String)"LBL_PathDesc");
            propertyArray[0] = new ColumnDescriptor<String>("path", String.class, string, string2);
            this.setProperties(propertyArray);
        }

        private void setDefaultColumnSizes() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = ProjectOutlineView.this.getWidth();
                    ProjectOutlineView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 40 / 100);
                    ProjectOutlineView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 60 / 100);
                }
            });
        }

        public void addNotify() {
            ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
            explorerManager.setRootContext((Node)ProjectsView.this.rootNode);
            explorerManager.setExploredContext((Node)ProjectsView.this.rootNode);
            this.expandNode((Node)ProjectsView.this.rootNode);
            super.addNotify();
        }
    }
}

