/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.openide.util.NbBundle;

public class FunctionImpl
implements Function {
    private static final Map<CsmDeclaration.Kind, CsmDeclaration.Kind> preferredIcons = new HashMap<CsmDeclaration.Kind, CsmDeclaration.Kind>();
    private CsmFunction function;
    private String htmlDisplayName = "";
    private String scopeName = null;

    public FunctionImpl(CsmFunction csmFunction) {
        this.function = csmFunction;
    }

    public CsmFunction getDeclaration() {
        CsmFunction csmFunction;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.function) && (csmFunction = ((CsmFunctionDefinition)this.function).getDeclaration()) != null) {
            return csmFunction;
        }
        return this.function;
    }

    public CsmFunction getDefinition() {
        CsmFunctionDefinition csmFunctionDefinition;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)this.function) && (csmFunctionDefinition = this.function.getDefinition()) != null) {
            return csmFunctionDefinition;
        }
        return this.function;
    }

    public String getName() {
        return ((Object)this.function.getName()).toString();
    }

    public String getScopeName() {
        if (this.scopeName == null) {
            this.scopeName = "";
            try {
                CsmClass csmClass;
                CsmFunction csmFunction = this.getDeclaration();
                if (CsmKindUtilities.isClassMember((CsmObject)csmFunction) && (csmClass = ((CsmMember)csmFunction).getContainingClass()) != null && csmClass.getName().length() > 0) {
                    this.scopeName = ((Object)csmClass.getName()).toString() + "::";
                }
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.scopeName;
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName.length() == 0) {
            this.htmlDisplayName = this.createHtmlDisplayName();
        }
        return this.htmlDisplayName;
    }

    public boolean isVurtual() {
        try {
            CsmClass csmClass;
            CsmFunction csmFunction = this.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)csmFunction) && (csmClass = ((CsmMember)csmFunction).getContainingClass()) != null && csmClass.getName().length() > 0) {
                return CsmKindUtilities.isMethod((CsmObject)csmFunction) && CsmVirtualInfoQuery.getDefault().isVirtual((CsmMethod)csmFunction);
            }
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private String createHtmlDisplayName() {
        String string = ((Object)this.function.getName()).toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if (this.scopeName == null) {
            this.scopeName = "";
        }
        try {
            CsmClass csmClass;
            CsmFunction csmFunction = this.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)csmFunction) && (csmClass = ((CsmMember)csmFunction).getContainingClass()) != null && csmClass.getName().length() > 0) {
                String string2 = ((Object)csmClass.getName()).toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                String string3 = NbBundle.getMessage(CallImpl.class, (String)"LBL_inClass");
                if (this.isVurtual()) {
                    string = "<i>" + string + "</i>";
                }
                this.scopeName = ((Object)csmClass.getName()).toString() + "::";
                return string + "<font color='!controlShadow'>  " + string3 + " " + string2;
            }
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getDescription() {
        return this.scopeName + ((Object)this.function.getSignature()).toString();
    }

    public Image getIcon() {
        try {
            return CsmImageLoader.getImage((CsmObject)this.getDefinition(), preferredIcons);
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void open() {
        CsmUtilities.openSource((CsmObject)this.getDefinition());
    }

    public boolean equals(Object object) {
        CsmFunction csmFunction = this.getDeclaration();
        if (csmFunction != null && object instanceof FunctionImpl) {
            return csmFunction.equals(((FunctionImpl)object).getDeclaration());
        }
        return super.equals(object);
    }

    public int hashCode() {
        CsmFunction csmFunction = this.getDeclaration();
        if (csmFunction != null) {
            return csmFunction.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    static {
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION);
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_FRIEND);
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION);
    }
}

