/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.jna.MemoryUtil;

public abstract class AbstractMemoryIO
extends MemoryIO {
    protected static final void checkBounds(long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int indexOf(long offset2, byte value2) {
        return this.indexOf(offset2, value2, Integer.MAX_VALUE);
    }

    public long getAddress(long offset2) {
        return AddressIO.INSTANCE.getAddress(this, offset2);
    }

    public void putAddress(long offset2, long value2) {
        AddressIO.INSTANCE.putAddress(this, offset2, value2);
    }

    public void putAddress(long offset2, Address value2) {
        AddressIO.INSTANCE.putAddress(this, offset2, value2.longValue());
    }

    public final long getNativeLong(long offset2) {
        return NativeLongIO.INSTANCE.getLong(this, offset2);
    }

    public MemoryIO slice(long offset2) {
        return MemoryUtil.slice(this, offset2);
    }

    public MemoryIO slice(long offset2, long size2) {
        return MemoryUtil.slice(this, offset2, size2);
    }

    public void putNativeLong(long offset2, long value2) {
        NativeLongIO.INSTANCE.putLong(this, offset2, value2);
    }

    public void transferTo(long offset2, MemoryIO other, long otherOffset, long count2) {
        for (long i = 0L; i < count2; ++i) {
            other.putByte(otherOffset + i, this.getByte(offset2 + i));
        }
    }

    public void transferFrom(long offset2, MemoryIO other, long otherOffset, long count2) {
        for (long i = 0L; i < count2; ++i) {
            this.putByte(offset2 + i, other.getByte(otherOffset + i));
        }
    }

    private static interface NativeLongIO {
        public static final NativeLongIO INSTANCE = Platform.getPlatform().longSize() == 32 ? LongIO32._INSTANCE : LongIO64._INSTANCE;

        public long getLong(MemoryIO var1, long var2);

        public void putLong(MemoryIO var1, long var2, long var4);

        public static class LongIO64
        implements NativeLongIO {
            public static final NativeLongIO _INSTANCE = new LongIO64();

            public long getLong(MemoryIO io2, long offset2) {
                return io2.getLong(offset2);
            }

            public void putLong(MemoryIO io2, long offset2, long value2) {
                io2.putLong(offset2, value2);
            }
        }

        public static class LongIO32
        implements NativeLongIO {
            public static final NativeLongIO _INSTANCE = new LongIO32();

            public long getLong(MemoryIO io2, long offset2) {
                return io2.getInt(offset2);
            }

            public void putLong(MemoryIO io2, long offset2, long value2) {
                io2.putInt(offset2, (int)value2);
            }
        }
    }

    private static interface AddressIO {
        public static final AddressIO INSTANCE = Platform.getPlatform().addressSize() == 32 ? AddressIO32._INSTANCE : AddressIO64._INSTANCE;

        public long getAddress(MemoryIO var1, long var2);

        public void putAddress(MemoryIO var1, long var2, long var4);

        public static class AddressIO64 {
            public static final AddressIO _INSTANCE = new AddressIO32();

            public long getAddress(MemoryIO io2, long offset2) {
                return io2.getLong(offset2);
            }

            public void putAddress(MemoryIO io2, long offset2, long address2) {
                io2.putLong(offset2, address2);
            }
        }

        public static class AddressIO32
        implements AddressIO {
            public static final AddressIO _INSTANCE = new AddressIO32();

            public long getAddress(MemoryIO io2, long offset2) {
                return io2.getInt(offset2);
            }

            public void putAddress(MemoryIO io2, long offset2, long address2) {
                io2.putInt(offset2, (int)address2);
            }
        }
    }
}

