/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.MemoryManager;
import com.kenai.jaffl.provider.jna.BufferMemoryIO;
import com.kenai.jaffl.provider.jna.JNAPointer;
import com.kenai.jaffl.provider.jna.PointerMemoryIO;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class JNAMemoryManager
implements MemoryManager {
    JNAMemoryManager() {
    }

    public MemoryIO allocate(int size2) {
        return this.allocateDirect(size2, true);
    }

    public MemoryIO allocateDirect(int size2) {
        return new PointerMemoryIO(new Memory(size2));
    }

    public MemoryIO allocateDirect(int size2, boolean clear2) {
        Memory m = new Memory(size2);
        if (clear2) {
            m.clear();
        }
        return new PointerMemoryIO(m);
    }

    public MemoryIO wrap(Pointer address2) {
        return new PointerMemoryIO(((JNAPointer)address2).getNativePointer());
    }

    public MemoryIO wrap(Pointer address2, int size2) {
        return new PointerMemoryIO(((JNAPointer)address2).getNativePointer());
    }

    public MemoryIO wrap(ByteBuffer buffer) {
        return new BufferMemoryIO(buffer);
    }

    public Pointer getBufferPointer(Buffer buffer) {
        return new JNAPointer(Native.getDirectBufferPointer(buffer));
    }
}

