/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class JavaMethodDescriptor {
    public final boolean isStatic;
    public final boolean hasContext;
    public final boolean hasBlock;
    public final boolean hasVarArgs;
    public final int actualRequired;
    public final int arity;
    public final int required;
    public final int optional;
    public final boolean rest;
    private final Class[] parameters;
    private final Class returnClass;
    public final JRubyMethod anno;
    public final int modifiers;
    private final Class declaringClass;
    public final String declaringClassName;
    public final String declaringClassPath;
    public final String name;
    public final String signature;
    public final Class[] argumentTypes;

    public JavaMethodDescriptor(Method method2) {
        int args2;
        this.anno = method2.getAnnotation(JRubyMethod.class);
        this.modifiers = method2.getModifiers();
        this.declaringClass = method2.getDeclaringClass();
        this.declaringClassName = this.declaringClass.getName();
        this.declaringClassPath = CodegenUtils.p(this.declaringClass);
        this.name = method2.getName();
        this.isStatic = Modifier.isStatic(this.modifiers);
        this.parameters = method2.getParameterTypes();
        this.returnClass = method2.getReturnType();
        if (this.parameters.length > 0) {
            this.hasContext = this.parameters[0] == ThreadContext.class;
            this.hasBlock = this.parameters[this.parameters.length - 1] == Block.class;
        } else {
            this.hasContext = false;
            this.hasBlock = false;
        }
        this.hasVarArgs = this.hasContext ? (this.hasBlock ? this.parameters[this.parameters.length - 2] == IRubyObject[].class : this.parameters[this.parameters.length - 1] == IRubyObject[].class) : (this.hasBlock ? this.parameters.length > 1 && this.parameters[this.parameters.length - 2] == IRubyObject[].class : this.parameters.length > 0 && this.parameters[this.parameters.length - 1] == IRubyObject[].class);
        int start2 = (this.hasContext ? 1 : 0) + (this.isStatic ? 1 : 0);
        int end2 = this.parameters.length - (this.hasBlock ? 1 : 0);
        this.argumentTypes = new Class[end2 - start2];
        System.arraycopy(this.parameters, start2, this.argumentTypes, 0, end2 - start2);
        this.optional = this.anno.optional();
        this.rest = this.anno.rest();
        this.required = this.anno.required();
        if (this.optional == 0 && !this.rest) {
            args2 = this.parameters.length;
            if (args2 == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --args2;
                }
                if (this.hasContext) {
                    --args2;
                }
                if (this.hasBlock) {
                    --args2;
                }
                this.actualRequired = args2;
            }
        } else {
            args2 = this.parameters.length;
            if (args2 == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --args2;
                }
                if (this.hasContext) {
                    --args2;
                }
                if (this.hasBlock) {
                    --args2;
                }
                this.actualRequired = --args2;
            }
            if (this.actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
            }
        }
        int arityRequired = Math.max(this.required, this.actualRequired);
        this.arity = this.optional > 0 || this.rest ? -(arityRequired + 1) : arityRequired;
        this.signature = CodegenUtils.sig(method2.getReturnType(), method2.getParameterTypes());
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getParameterClasses() {
        return this.parameters;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }
}

