/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarNode
extends Node
implements INameNode {
    private String name;

    public ClassVarNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassVarNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(this.name);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject attached;
        RubyModule module = context.getCurrentScope().getStaticScope().getModule();
        if (module == null && self.getMetaClass().fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        if (module.fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        IRubyObject iRubyObject = attached = module.isSingleton() ? ((MetaClass)module).getAttached() : null;
        if (attached instanceof RubyModule && ((RubyModule)attached).fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        return null;
    }
}

